// Boundary_triangle_mesh.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/math/geometry/Boundary_triangle_mesh.hpp>
#include <tovero/math/geometry/Triangle_mesh.hpp>
#include <tovero/math/geometry/Triangle_face.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>
#include <vector>

using std::string;
using std::vector;
using namespace Roan_trail::Tovero_math;

//
// Constructors
//

Boundary_triangle_mesh::Boundary_triangle_mesh(Triangle_face::Triangle_direction_type triangle_direction,
                                               const vector<Point>& vertices,
                                               const vector<Triangle_face>& faces,
                                               const vector<Vector>& normals,
                                               const vector<Triangle_face>& face_normals,
                                               bool has_surface_normals,
                                               bool use_surface_normals,
                                               const string& name)
  : Triangle_mesh(triangle_direction,
                  vertices,
                  faces,
                  normals,
                  face_normals,
                  has_surface_normals,
                  use_surface_normals,
                  name)
{
}
