// Cone.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Right circular cone

#ifndef TOVERO_MATH_CONE_HPP_
#define TOVERO_MATH_CONE_HPP_

#include <tovero/math/geometry/General_cone_base.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class General_cone;
    class Geometric_tolerances;

    class Cone : public General_cone_base
    {
    public:
      // constructor/copy
      //   Defaults to a cylinder of radius of 1.0 with the base centered at the origin
      Cone(const std::string& name = "");
      Cone(const Point& base,
           const Vector& height,
           const Distance& base_radius,
           const Distance& top_radius,
           const std::string& name = "");
      virtual Solid* clone_solid() const { return new Cone(*this); }
      //   Note: let compiler generate default constructor and operator=
      // accessors/mutators
      const Point& base() const { return m_base; }
      void set_base(const Point& base) { m_base = base; }
      const Vector& height() const { return m_height; }
      void set_height(const Vector& height) { m_height = height; }
      const Distance& base_radius() const { return m_base_radius; }
      void set_base_radius(const Distance& base_radius) { m_base_radius = base_radius; }
      const Distance& top_radius() const { return m_top_radius; }
      void set_top_radius(const Distance& top_radius) { m_top_radius = top_radius; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Cone"; }
      virtual General_cone& generalize() const;
      virtual Solid& specialize(const Geometric_tolerances& tolerances) const;
    protected:
      // destructor
      virtual ~Cone() {}
    private:
      // solid parameters
      Point m_base; // base center point
      Vector m_height;
      Distance m_base_radius;
      Distance m_top_radius;
    };
  }
}

#endif // TOVERO_MATH_CONE_HPP_
