// General_cone_base.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Base class for general cone objects

#ifndef TOVERO_MATH_GENERAL_CONE_BASE_HPP_
#define TOVERO_MATH_GENERAL_CONE_BASE_HPP_

#include <tovero/math/geometry/Solid.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class General_cone;
    class Geometric_tolerances;

    class General_cone_base : public Solid
    {
    public:
      // other
      virtual General_cone& generalize() const = 0;
    protected:
      explicit General_cone_base(const std::string& name) : Solid(name) {}
    };
  }
}

#endif // TOVERO_MATH_GENERAL_CONE_BASE_HPP_
