// Geometric_tolerances.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_MATH_GEOMETRIC_TOLERANCES_HPP_
#define TOVERO_MATH_GEOMETRIC_TOLERANCES_HPP_

#include <tovero/math/geometry/Area.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Unitless.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    struct Geometric_tolerances
    {
      // constructor
      inline Geometric_tolerances(Distance distance_value = Distance::from_value(1.0E-6),
                                  Area area_value = Area::from_value(2.0E-4),
                                  Unitless cosine_value = Unitless::from_value(1.0E-3),
                                  Unitless unitless_value = Unitless::from_value(1.0E-6));
      //   Note: for angle Angle default radians = 0.05729579 degrees
      // predicates
      bool is_distance_near_zero(const Distance& value) const
      { return (value > -distance) && (value < distance); }
      bool is_area_near_zero(const Area& value) const
      { return (value > -area) && (value < area); }
      bool is_cosine_near_zero(const Unitless& value) const
      { return (value > -cosine) && (value < cosine); }
      bool is_unitless_near_zero(const Unitless& value) const
      { return (value > -unitless) && (value < unitless); }
      static bool is_near_zero(double value, double tolerance)
      { return (value > -tolerance) && (value < tolerance); }
      // structure data members
      Distance distance;
      Area area;
      Unitless cosine;
      Unitless unitless;
    };

    // free functions

    template <class Quantity>
    static bool is_quantity_near_zero(const Quantity& value, const Quantity& tolerance)
    { return (value > -tolerance) && (value < tolerance); }

    //
    // Inline definitions
    //

    //
    //   Constructor
    //

    inline Geometric_tolerances::Geometric_tolerances(Distance distance_value,
                                                      Area area_value,
                                                      Unitless cosine_value,
                                                      Unitless unitless_value)
      : distance(distance_value),
        area(area_value),
        cosine(cosine_value),
        unitless(unitless_value)
    {
    }
  }
}

#endif // TOVERO_MATH_GEOMETRIC_TOLERANCES_HPP_
