// Solid_combination.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/math/geometry/Solid_combination.hpp>
#include <tovero/math/geometry/Solid_combination_base.hpp>
#include <tovero/math/geometry/Solid_member.hpp>
#include <tovero/math/geometry/Solid_operand.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <list>
#include <string>
#include <cstddef>

using std::list;
using std::string;
using Roan_trail::Tovero_support::Reference_counting_list;
using namespace Roan_trail::Tovero_math;

//
// Constructor/copy
//

Solid_combination::Solid_combination(const Reference_counting_list<Solid_member>& members,
                                     const string& name)
  : Solid_combination_base(name),
    m_members(members)
{
}

Solid_combination::Solid_combination(const string& name)
  : Solid_combination_base(name),
    m_members()
{
}

Solid_combination::Solid_combination(const Solid_combination& c)
 : Solid_combination_base(c)
{
  m_members = c.m_members;
}

Solid_combination& Solid_combination::operator=(const Solid_combination& c)
{
  if (this != &c)
  {
    Solid_combination_base::operator=(c);
    m_members = c.m_members;
  }

  return *this;
}

//
// Accessors/mutators
//

void Solid_combination::add_member(Solid_member& member)
{
  m_members.push_back(member);
}

void Solid_combination::add_member(Solid& member)
{
  m_members.push_back(*(new Solid_member(member)));
}

//
// Visitor
//

Solid_visitor::Visit_result Solid_combination::accept(Solid_visitor& visitor) const
{
  Solid_visitor::Visit_result result = visitor.visit_enter(*this);
  if (Solid_visitor::success != result)
  {
    goto exit_point;
  }

  for (Reference_counting_list<Solid_member>::const_iterator i = m_members.begin();
       i != m_members.end();
       ++i)
  {
    const Solid_member& member = **i;
    result = member.operand().solid().accept(visitor);
    if (Solid_visitor::success != result)
    {
      goto exit_point;
    }
  }

  result = visitor.visit_exit(*this);

 exit_point:
  return result;
}

