// Solid_combination_base.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Base class for solid combination objects

#ifndef TOVERO_MATH_SOLID_COMBINATION_BASE_HPP_
#define TOVERO_MATH_SOLID_COMBINATION_BASE_HPP_

#include <tovero/math/geometry/Solid.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid_combination_base : public Solid
    {
    protected:
      Solid_combination_base(const std::string& name = "") : Solid(name) {}
      Solid_combination_base(const Solid_combination_base& s) : Solid(s) {}
      inline Solid_combination_base& operator=(const Solid_combination_base& s);
      virtual ~Solid_combination_base() {}
    };

    //
    // Inline definitions
    //

    inline Solid_combination_base& Solid_combination_base::operator=(const Solid_combination_base& c)
    {
      if (&c != this)
      {
        Solid::operator=(c);
      }

      return *this;
    }
  }
}

#endif // TOVERO_MATH_SOLID_COMBINATION_BASE_HPP_
