// Solid_operation.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Solid composed of a boolean operation of two other solids

#ifndef TOVERO_MATH_SOLID_OPERATION_HPP_
#define TOVERO_MATH_SOLID_OPERATION_HPP_

#include <tovero/math/geometry/Solid_combination_base.hpp>
#include <tovero/math/geometry/Solid_operator.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid_operand;

    class Solid_operation : public Solid_combination_base
    {
    public:
      // constructor/copy
      Solid_operation(Solid_operand& left_operand, // Note: referenced, not const
                      Solid_operand& right_operand, // Note: referenced, not const
                      Solid_operator::Solid_operator_type op = Solid_operator::union_op, // (check_code_ignore)
                      const std::string& name = "");
      Solid_operation(const Solid_operation& o);
      Solid_operation& operator=(const Solid_operation& o);
      virtual Solid* clone_solid() const { return new Solid_operation(*this); }
      // accessors/mutators
      Solid_operand& left_operand() const { return *m_left_operand; } // Note: referenced, not returned as const
      void set_left_operand(Solid_operand& left_operand);
      Solid_operand& right_operand() const { return *m_right_operand; } // Note: referenced, not returned as const
      void set_right_operand(Solid_operand& left_operand);
      Solid_operator::Solid_operator_type op() const { return m_op; }
      void set_op(Solid_operator::Solid_operator_type op) { m_op = op; }
      // class constants
      // predicates
      virtual bool is_primitive() const { return false; }
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const;
      // other
      virtual std::string solid_class() const { return "Solid_operation"; }
    protected:
      // destructor
      virtual ~Solid_operation();
      // class invariant
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Solid_operand* m_left_operand;
      Solid_operand* m_right_operand;
      Solid_operator::Solid_operator_type m_op;
    };
  }
}

#endif // TOVERO_MATH_SOLID_OPERATION_HPP_
