// Wedge.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Right angle wedge, specialized Polyhedron (6 vertex)

#ifndef TOVERO_MATH_WEDGE_HPP_
#define TOVERO_MATH_WEDGE_HPP_

#include <tovero/math/geometry/Polyhedron_base.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Polyhedron;

    class Wedge : public Polyhedron_base
    {
    public:
      // constructor/copy
      Wedge(const std::string& name = "");
      Wedge(const Point& vertex,
            const Vector& width,
            const Vector& height,
            const Vector& depth,
            const std::string& name = "");
      virtual Solid* clone_solid() const { return new Wedge(*this); }
      //   Note: let compiler generate default copy constructor and operator=
      // accessors/mutators
      const Point& vertex() const { return m_vertex; }
      void set_vertex(const Point& vertex) { m_vertex = vertex; }
      const Vector& height() const { return m_height; }
      void set_height(const Vector& height) { m_height = height; }
      const Vector& width() const { return m_width; }
      void set_width(const Vector& width) { m_width = width; }
      const Vector& depth() const { return m_depth; }
      void set_depth(const Vector& depth) { m_depth = depth; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Wedge"; }
      virtual Polyhedron& generalize() const;
    protected:
      // destructor
      virtual ~Wedge() {}
    private:
      // solid parameters
      Point m_vertex; // lower left corner
      Vector m_width;
      Vector m_height;
      Vector m_depth;
    };
  }
}

#endif // TOVERO_MATH_WEDGE_HPP_
