# test_oblique_cone.rb
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Oblique_cone class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_0'
require 'libtovero_math_rb_0'

include Libtovero_support_rb_0
include Libtovero_math_rb_0

class TestObliqueCone < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
    @Zero_length_vector = Vector.new
  end

  #
  # Solid validity checks
  #

  def test_default
    cone = ObliqueCone.new
    error = ErrorParam.new
    #
    assert cone.is_valid?(@Tolerances, error)
  end

  def test_zero_length_height
    cone = ObliqueCone.new
    cone.name = "cone"
    cone.height = @Zero_length_vector
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_zero_length_base_r
    cone = ObliqueCone.new
    cone.name = "cone"
    cone.base_r = @Zero_length_vector
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_parallel_height_base_r
    cone = ObliqueCone.new
    v = UnitVector::y * Distance::meter
    cone.height = v
    cone.base_r = v
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_negative_ratio
    cone = ObliqueCone.new
    cone.ratio = Unitless.new(-1.0)
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    cone = ObliqueCone.new
    #
    assert_respond_to cone, :base
    assert_respond_to cone, :base=
    assert_respond_to cone, :height
    assert_respond_to cone, :height=
    assert_respond_to cone, :base_r
    assert_respond_to cone, :base_r=
    assert_respond_to cone, :ratio
    assert_respond_to cone, :ratio=
  end

end
