// Boost_error.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/support/error/Boost_error.hpp>
#include <tovero/support/common.hpp>
#include <boost/system/error_code.hpp>
#include <string>

using boost::system::error_code;
using std::string;
using namespace Roan_trail::Tovero_support;

//
// Constructor/destructor/copy
//
Boost_error::Boost_error(const char* file,
                         const char* function,
                         int line,
                         const error_code& ec,
                         const Error *base_error)
  : Error(file,
          function,
          line,
          ec.value(),
          base_error)
{
  if ("" != ec.message())
  {
    error_dictionary()[Error::diagnostic_error_key] = ec.message();
  }

  postcondition(mf_invariant(false));
}

Boost_error::Boost_error(const char* file,
                         const char* function,
                         int line,
                         const string& diagnostic,
                         const Error* base_error)
  : Error(file,
          function,
          line,
          0,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  postcondition(mf_invariant(false));
}

//
// Error key
//

const string Boost_error::program_options_error_key = string("program_options_error_key");

//
// Protected member functions
//

bool Boost_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  return_value = (!check_base_class || Error::mf_invariant(check_base_class));

  goto exit_point;

 exit_point:

  return return_value;
}
