// Math_error.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/support/error/Math_error.hpp>
#include <tovero/support/common.hpp>
#include <string>

using std::string;
using namespace Roan_trail::Tovero_support;

//
// Constructor/destructor/copy
//

Math_error::Math_error(const char* file,
                       const char* function,
                       int line,
                       int code,
                       const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  postcondition(mf_invariant(false));
}

Math_error::Math_error(const char* file,
                       const char* function,
                       int line,
                       int code,
                       const string& diagnostic,
                       const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  postcondition(mf_invariant(false));
}

//
// Protected member functions
//

bool Math_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if ((code() < Math_error::none) || (code() > Math_error::validation))
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:
  return return_value;
}
