#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-func4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-func4.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ . ../commands.sh
$ print '\''a]b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a]b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\'']'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a[b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a[b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''['\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a{b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a{b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''{'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a}b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a}b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''}'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a(b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a(b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''('\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a)b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a)b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\'')'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a^b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a^b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''^'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a$b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a$b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''$'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a|b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a|b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''|'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a.b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a.b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''.'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a?b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a?b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''?'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a*b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a*b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''*'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a+b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a+b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''+'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a&b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a&b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''&'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a/b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a/b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''/'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}
$ print '\''a\b =ab'\''|gen-func -h ..
bool lookup(const char* n, result_t& t)
{
    // pattern: a\b
    if (*n ++ == '\''a'\'' &&
        *n ++ == '\''\\'\'' &&
        *n ++ == '\''b'\'' &&
        *n == 0) {
        t = result_t::ab;
        return true;
    }
    return false;
}'
) -L gen-func4.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ . ../commands.sh'
. ../commands.sh 2>&1 ||
echo 'command failed: . ../commands.sh'

echo '$ print '\''a]b =ab'\''|gen-func -h ..'
print 'a]b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a]b =ab'\''|gen-func -h ..'

echo '$ print '\''a[b =ab'\''|gen-func -h ..'
print 'a[b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a[b =ab'\''|gen-func -h ..'

echo '$ print '\''a{b =ab'\''|gen-func -h ..'
print 'a{b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a{b =ab'\''|gen-func -h ..'

echo '$ print '\''a}b =ab'\''|gen-func -h ..'
print 'a}b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a}b =ab'\''|gen-func -h ..'

echo '$ print '\''a(b =ab'\''|gen-func -h ..'
print 'a(b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a(b =ab'\''|gen-func -h ..'

echo '$ print '\''a)b =ab'\''|gen-func -h ..'
print 'a)b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a)b =ab'\''|gen-func -h ..'

echo '$ print '\''a^b =ab'\''|gen-func -h ..'
print 'a^b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a^b =ab'\''|gen-func -h ..'

echo '$ print '\''a$b =ab'\''|gen-func -h ..'
print 'a$b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a$b =ab'\''|gen-func -h ..'

echo '$ print '\''a|b =ab'\''|gen-func -h ..'
print 'a|b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a|b =ab'\''|gen-func -h ..'

echo '$ print '\''a.b =ab'\''|gen-func -h ..'
print 'a.b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a.b =ab'\''|gen-func -h ..'

echo '$ print '\''a?b =ab'\''|gen-func -h ..'
print 'a?b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a?b =ab'\''|gen-func -h ..'

echo '$ print '\''a*b =ab'\''|gen-func -h ..'
print 'a*b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a*b =ab'\''|gen-func -h ..'

echo '$ print '\''a+b =ab'\''|gen-func -h ..'
print 'a+b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a+b =ab'\''|gen-func -h ..'

echo '$ print '\''a&b =ab'\''|gen-func -h ..'
print 'a&b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a&b =ab'\''|gen-func -h ..'

echo '$ print '\''a/b =ab'\''|gen-func -h ..'
print 'a/b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a/b =ab'\''|gen-func -h ..'

echo '$ print '\''a\b =ab'\''|gen-func -h ..'
print 'a\b =ab'|gen-func -h .. 2>&1 ||
echo 'command failed: print '\''a\b =ab'\''|gen-func -h ..'
)

