#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-compact-trie-base
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-compact-trie-base.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --gen=compact --output=trie --attrs --no-dots "$@"; }
$ print a ab abc abd ac|trie
[1,'\''a'\''] {
    "a" [0,"",'\''a'\'',[2,'\''c'\'']]: "a" {
        "b" [0,"",'\''b'\'',[2,'\''d'\'']]: "ab" {
            "c" [0,"",'\''c'\'',[0]]: "abc"
            "d" [0,"",'\''d'\'',[0]]: "abd"
        }
        "c" [0,"",'\''c'\'',[0]]: "ac"
    }
}
$ print a ab abc abd ac|trie -t int
[1,'\''a'\''] {
    "a" [0,"",'\''a'\'',[2,'\''c'\'']]: 1 {
        "b" [0,"",'\''b'\'',[2,'\''d'\'']]: 2 {
            "c" [0,"",'\''c'\'',[0]]: 3
            "d" [0,"",'\''d'\'',[0]]: 4
        }
        "c" [0,"",'\''c'\'',[0]]: 5
    }
}
$ print a ab abc abd ac|trie -t float
[1,'\''a'\''] {
    "a" [0,"",'\''a'\'',[2,'\''c'\'']]: 1.0 {
        "b" [0,"",'\''b'\'',[2,'\''d'\'']]: 2.0 {
            "c" [0,"",'\''c'\'',[0]]: 3.0
            "d" [0,"",'\''d'\'',[0]]: 4.0
        }
        "c" [0,"",'\''c'\'',[0]]: 5.0
    }
}'
) -L gen-compact-trie-base.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --gen=compact --output=trie --attrs --no-dots "$@"; }'
trie() { ../src/trie --gen=compact --output=trie --attrs --no-dots "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --gen=compact --output=trie --attrs --no-dots "$@"; }'

echo '$ print a ab abc abd ac|trie'
print a ab abc abd ac|trie 2>&1 ||
echo 'command failed: print a ab abc abd ac|trie'

echo '$ print a ab abc abd ac|trie -t int'
print a ab abc abd ac|trie -t int 2>&1 ||
echo 'command failed: print a ab abc abd ac|trie -t int'

echo '$ print a ab abc abd ac|trie -t float'
print a ab abc abd ac|trie -t float 2>&1 ||
echo 'command failed: print a ab abc abd ac|trie -t float'
)

