#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-func3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-func3.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ . ../commands.sh
$ print '\''a]b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\]b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a[b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\[b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a{b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\{b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a}b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\}b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a(b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\(b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a)b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\)b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a^b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\^b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a$b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\$b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a|b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\|b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a.b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\.b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a?b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\?b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a*b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\*b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a+b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\+b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a&b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\&b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a/b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\/b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/
$ print '\''a\b =ab'\''|gen-func -h .. -R
            s/^(\t+)(\t)return\s*(\x22(a\\\\b)\x22);\s*$/\1\2t = result_t::ab;\n\1\2return true;\n\1}/'
) -L gen-func3.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ . ../commands.sh'
. ../commands.sh 2>&1 ||
echo 'command failed: . ../commands.sh'

echo '$ print '\''a]b =ab'\''|gen-func -h .. -R'
print 'a]b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a]b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a[b =ab'\''|gen-func -h .. -R'
print 'a[b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a[b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a{b =ab'\''|gen-func -h .. -R'
print 'a{b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a{b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a}b =ab'\''|gen-func -h .. -R'
print 'a}b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a}b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a(b =ab'\''|gen-func -h .. -R'
print 'a(b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a(b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a)b =ab'\''|gen-func -h .. -R'
print 'a)b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a)b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a^b =ab'\''|gen-func -h .. -R'
print 'a^b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a^b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a$b =ab'\''|gen-func -h .. -R'
print 'a$b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a$b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a|b =ab'\''|gen-func -h .. -R'
print 'a|b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a|b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a.b =ab'\''|gen-func -h .. -R'
print 'a.b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a.b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a?b =ab'\''|gen-func -h .. -R'
print 'a?b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a?b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a*b =ab'\''|gen-func -h .. -R'
print 'a*b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a*b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a+b =ab'\''|gen-func -h .. -R'
print 'a+b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a+b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a&b =ab'\''|gen-func -h .. -R'
print 'a&b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a&b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a/b =ab'\''|gen-func -h .. -R'
print 'a/b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a/b =ab'\''|gen-func -h .. -R'

echo '$ print '\''a\b =ab'\''|gen-func -h .. -R'
print 'a\b =ab'|gen-func -h .. -R 2>&1 ||
echo 'command failed: print '\''a\b =ab'\''|gen-func -h .. -R'
)

