#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-wide-c-code-alphabets-ternary
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-wide-c-code-alphabets-ternary.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ ../src/trie --attrs --dots --gen=wide --output=c-code --trie=ternary < alphabets.txt
.   // [25,'\''z'\'']
.   switch (*p ++) {
.   // '\''a'\'' [8,'\''z'\'']
.   case '\''a'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "aa";
.   .   .   return error;
.   .   // '\''f'\'' [0]
.   .   case '\''f'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "af";
.   .   .   return error;
.   .   // '\''g'\'' [1,'\''q'\'']
.   .   case '\''g'\'':
.   .   .   // '\''q'\'' [0]
.   .   .   if (*p ++ == '\''q'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "agq";
.   .   .   }
.   .   .   return error;
.   .   // '\''k'\'' [0]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ak";
.   .   .   return error;
.   .   // '\''m'\'' [0]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "am";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ar";
.   .   .   return error;
.   .   // '\''s'\'' [2,'\''t'\'']
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "as";
.   .   .   switch (*p ++) {
.   .   .   // '\''a'\'' [0]
.   .   .   case '\''a'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "asa";
.   .   .   .   return error;
.   .   .   // '\''t'\'' [0]
.   .   .   case '\''t'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ast";
.   .   .   }
.   .   .   return error;
.   .   // '\''z'\'' [1,'\''_'\'']
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "az";
.   .   .   // '\''_'\'' [1,'\''C'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''C'\'' [1,'\''y'\'']
.   .   .   .   if (*p ++ == '\''C'\'') {
.   .   .   .   .   // '\''y'\'' [1,'\''r'\'']
.   .   .   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   .   .   // '\''r'\'' [1,'\''l'\'']
.   .   .   .   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   .   .   .   // '\''l'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''l'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "az_Cyrl";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''b'\'' [9,'\''y'\'']
.   case '\''b'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''s'\'']
.   .   case '\''a'\'':
.   .   .   // '\''s'\'' [0]
.   .   .   if (*p ++ == '\''s'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "bas";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [2,'\''z'\'']
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "be";
.   .   .   switch (*p ++) {
.   .   .   // '\''m'\'' [0]
.   .   .   case '\''m'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "bem";
.   .   .   .   return error;
.   .   .   // '\''z'\'' [0]
.   .   .   case '\''z'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "bez";
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bg";
.   .   .   return error;
.   .   // '\''m'\'' [0]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bm";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bn";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bo";
.   .   .   return error;
.   .   // '\''r'\'' [1,'\''x'\'']
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "br";
.   .   .   // '\''x'\'' [0]
.   .   .   if (*p ++ == '\''x'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "brx";
.   .   .   }
.   .   .   return error;
.   .   // '\''s'\'' [1,'\''_'\'']
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bs";
.   .   .   // '\''_'\'' [1,'\''C'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''C'\'' [1,'\''y'\'']
.   .   .   .   if (*p ++ == '\''C'\'') {
.   .   .   .   .   // '\''y'\'' [1,'\''r'\'']
.   .   .   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   .   .   // '\''r'\'' [1,'\''l'\'']
.   .   .   .   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   .   .   .   // '\''l'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''l'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "bs_Cyrl";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''y'\'' [1,'\''n'\'']
.   .   case '\''y'\'':
.   .   .   // '\''n'\'' [0]
.   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "byn";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''c'\'' [5,'\''y'\'']
.   case '\''c'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ca";
.   .   .   return error;
.   .   // '\''g'\'' [1,'\''g'\'']
.   .   case '\''g'\'':
.   .   .   // '\''g'\'' [0]
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "cgg";
.   .   .   }
.   .   .   return error;
.   .   // '\''h'\'' [1,'\''r'\'']
.   .   case '\''h'\'':
.   .   .   // '\''r'\'' [0]
.   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "chr";
.   .   .   }
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "cs";
.   .   .   return error;
.   .   // '\''y'\'' [0]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "cy";
.   .   }
.   .   return error;
.   // '\''d'\'' [6,'\''z'\'']
.   case '\''d'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''v'\'']
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "da";
.   .   .   // '\''v'\'' [0]
.   .   .   if (*p ++ == '\''v'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "dav";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [0]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "de";
.   .   .   return error;
.   .   // '\''j'\'' [1,'\''e'\'']
.   .   case '\''j'\'':
.   .   .   // '\''e'\'' [0]
.   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "dje";
.   .   .   }
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''a'\'']
.   .   case '\''u'\'':
.   .   .   // '\''a'\'' [0]
.   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "dua";
.   .   .   }
.   .   .   return error;
.   .   // '\''y'\'' [1,'\''o'\'']
.   .   case '\''y'\'':
.   .   .   // '\''o'\'' [0]
.   .   .   if (*p ++ == '\''o'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "dyo";
.   .   .   }
.   .   .   return error;
.   .   // '\''z'\'' [0]
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "dz";
.   .   }
.   .   return error;
.   // '\''e'\'' [9,'\''w'\'']
.   case '\''e'\'':
.   .   switch (*p ++) {
.   .   // '\''b'\'' [1,'\''u'\'']
.   .   case '\''b'\'':
.   .   .   // '\''u'\'' [0]
.   .   .   if (*p ++ == '\''u'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ebu";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [0]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ee";
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "el";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "en";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "eo";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "es";
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "et";
.   .   .   return error;
.   .   // '\''u'\'' [0]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "eu";
.   .   .   return error;
.   .   // '\''w'\'' [1,'\''o'\'']
.   .   case '\''w'\'':
.   .   .   // '\''o'\'' [0]
.   .   .   if (*p ++ == '\''o'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ewo";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''f'\'' [7,'\''y'\'']
.   case '\''f'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fa";
.   .   .   return error;
.   .   // '\''f'\'' [0]
.   .   case '\''f'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ff";
.   .   .   return error;
.   .   // '\''i'\'' [1,'\''l'\'']
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fi";
.   .   .   // '\''l'\'' [0]
.   .   .   if (*p ++ == '\''l'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "fil";
.   .   .   }
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fo";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fr";
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''r'\'']
.   .   case '\''u'\'':
.   .   .   // '\''r'\'' [0]
.   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "fur";
.   .   .   }
.   .   .   return error;
.   .   // '\''y'\'' [0]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fy";
.   .   }
.   .   return error;
.   // '\''g'\'' [6,'\''v'\'']
.   case '\''g'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ga";
.   .   .   return error;
.   .   // '\''d'\'' [0]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gd";
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gl";
.   .   .   return error;
.   .   // '\''s'\'' [1,'\''w'\'']
.   .   case '\''s'\'':
.   .   .   // '\''w'\'' [0]
.   .   .   if (*p ++ == '\''w'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "gsw";
.   .   .   }
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''z'\'']
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gu";
.   .   .   // '\''z'\'' [0]
.   .   .   if (*p ++ == '\''z'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "guz";
.   .   .   }
.   .   .   return error;
.   .   // '\''v'\'' [0]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gv";
.   .   }
.   .   return error;
.   // '\''h'\'' [6,'\''y'\'']
.   case '\''h'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''w'\'']
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ha";
.   .   .   // '\''w'\'' [0]
.   .   .   if (*p ++ == '\''w'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "haw";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [0]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "he";
.   .   .   return error;
.   .   // '\''i'\'' [0]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hi";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hr";
.   .   .   return error;
.   .   // '\''u'\'' [0]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hu";
.   .   .   return error;
.   .   // '\''y'\'' [0]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hy";
.   .   }
.   .   return error;
.   // '\''i'\'' [6,'\''t'\'']
.   case '\''i'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ia";
.   .   .   return error;
.   .   // '\''d'\'' [0]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "id";
.   .   .   return error;
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ig";
.   .   .   return error;
.   .   // '\''i'\'' [0]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ii";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "is";
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "it";
.   .   }
.   .   return error;
.   // '\''j'\'' [3,'\''m'\'']
.   case '\''j'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ja";
.   .   .   return error;
.   .   // '\''g'\'' [1,'\''o'\'']
.   .   case '\''g'\'':
.   .   .   // '\''o'\'' [0]
.   .   .   if (*p ++ == '\''o'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "jgo";
.   .   .   }
.   .   .   return error;
.   .   // '\''m'\'' [1,'\''c'\'']
.   .   case '\''m'\'':
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "jmc";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''k'\'' [13,'\''y'\'']
.   case '\''k'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [2,'\''m'\'']
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ka";
.   .   .   switch (*p ++) {
.   .   .   // '\''b'\'' [0]
.   .   .   case '\''b'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kab";
.   .   .   .   return error;
.   .   .   // '\''m'\'' [0]
.   .   .   case '\''m'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kam";
.   .   .   }
.   .   .   return error;
.   .   // '\''d'\'' [1,'\''e'\'']
.   .   case '\''d'\'':
.   .   .   // '\''e'\'' [0]
.   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kde";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [1,'\''a'\'']
.   .   case '\''e'\'':
.   .   .   // '\''a'\'' [0]
.   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kea";
.   .   .   }
.   .   .   return error;
.   .   // '\''h'\'' [1,'\''q'\'']
.   .   case '\''h'\'':
.   .   .   // '\''q'\'' [0]
.   .   .   if (*p ++ == '\''q'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "khq";
.   .   .   }
.   .   .   return error;
.   .   // '\''i'\'' [0]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ki";
.   .   .   return error;
.   .   // '\''k'\'' [1,'\''j'\'']
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kk";
.   .   .   // '\''j'\'' [0]
.   .   .   if (*p ++ == '\''j'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kkj";
.   .   .   }
.   .   .   return error;
.   .   // '\''l'\'' [1,'\''n'\'']
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kl";
.   .   .   // '\''n'\'' [0]
.   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kln";
.   .   .   }
.   .   .   return error;
.   .   // '\''m'\'' [0]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "km";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kn";
.   .   .   return error;
.   .   // '\''o'\'' [1,'\''k'\'']
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ko";
.   .   .   // '\''k'\'' [0]
.   .   .   if (*p ++ == '\''k'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kok";
.   .   .   }
.   .   .   return error;
.   .   // '\''s'\'' [3,'\''h'\'']
.   .   case '\''s'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''b'\'' [0]
.   .   .   case '\''b'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksb";
.   .   .   .   return error;
.   .   .   // '\''f'\'' [0]
.   .   .   case '\''f'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksf";
.   .   .   .   return error;
.   .   .   // '\''h'\'' [0]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksh";
.   .   .   }
.   .   .   return error;
.   .   // '\''w'\'' [0]
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kw";
.   .   .   return error;
.   .   // '\''y'\'' [0]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ky";
.   .   }
.   .   return error;
.   // '\''l'\'' [8,'\''v'\'']
.   case '\''l'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''g'\'']
.   .   case '\''a'\'':
.   .   .   // '\''g'\'' [0]
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "lag";
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lg";
.   .   .   return error;
.   .   // '\''k'\'' [1,'\''t'\'']
.   .   case '\''k'\'':
.   .   .   // '\''t'\'' [0]
.   .   .   if (*p ++ == '\''t'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "lkt";
.   .   .   }
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ln";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lo";
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lt";
.   .   .   return error;
.   .   // '\''u'\'' [2,'\''y'\'']
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lu";
.   .   .   switch (*p ++) {
.   .   .   // '\''o'\'' [0]
.   .   .   case '\''o'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "luo";
.   .   .   .   return error;
.   .   .   // '\''y'\'' [0]
.   .   .   case '\''y'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "luy";
.   .   .   }
.   .   .   return error;
.   .   // '\''v'\'' [0]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lv";
.   .   }
.   .   return error;
.   // '\''m'\'' [12,'\''y'\'']
.   case '\''m'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''s'\'']
.   .   case '\''a'\'':
.   .   .   // '\''s'\'' [0]
.   .   .   if (*p ++ == '\''s'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mas";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [1,'\''r'\'']
.   .   case '\''e'\'':
.   .   .   // '\''r'\'' [0]
.   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mer";
.   .   .   }
.   .   .   return error;
.   .   // '\''f'\'' [1,'\''e'\'']
.   .   case '\''f'\'':
.   .   .   // '\''e'\'' [0]
.   .   .   if (*p ++ == '\''e'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mfe";
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [2,'\''o'\'']
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mg";
.   .   .   switch (*p ++) {
.   .   .   // '\''h'\'' [0]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mgh";
.   .   .   .   return error;
.   .   .   // '\''o'\'' [0]
.   .   .   case '\''o'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mgo";
.   .   .   }
.   .   .   return error;
.   .   // '\''k'\'' [0]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mk";
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ml";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mn";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mr";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ms";
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mt";
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''a'\'']
.   .   case '\''u'\'':
.   .   .   // '\''a'\'' [0]
.   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mua";
.   .   .   }
.   .   .   return error;
.   .   // '\''y'\'' [0]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "my";
.   .   }
.   .   return error;
.   // '\''n'\'' [11,'\''y'\'']
.   case '\''n'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''q'\'']
.   .   case '\''a'\'':
.   .   .   // '\''q'\'' [0]
.   .   .   if (*p ++ == '\''q'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "naq";
.   .   .   }
.   .   .   return error;
.   .   // '\''b'\'' [0]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nb";
.   .   .   return error;
.   .   // '\''d'\'' [0]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nd";
.   .   .   return error;
.   .   // '\''e'\'' [0]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ne";
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nl";
.   .   .   return error;
.   .   // '\''m'\'' [1,'\''g'\'']
.   .   case '\''m'\'':
.   .   .   // '\''g'\'' [0]
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "nmg";
.   .   .   }
.   .   .   return error;
.   .   // '\''n'\'' [1,'\''h'\'']
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nn";
.   .   .   // '\''h'\'' [0]
.   .   .   if (*p ++ == '\''h'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "nnh";
.   .   .   }
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nr";
.   .   .   return error;
.   .   // '\''s'\'' [1,'\''o'\'']
.   .   case '\''s'\'':
.   .   .   // '\''o'\'' [0]
.   .   .   if (*p ++ == '\''o'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "nso";
.   .   .   }
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''s'\'']
.   .   case '\''u'\'':
.   .   .   // '\''s'\'' [0]
.   .   .   if (*p ++ == '\''s'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "nus";
.   .   .   }
.   .   .   return error;
.   .   // '\''y'\'' [1,'\''n'\'']
.   .   case '\''y'\'':
.   .   .   // '\''n'\'' [0]
.   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "nyn";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''o'\'' [3,'\''s'\'']
.   case '\''o'\'':
.   .   switch (*p ++) {
.   .   // '\''m'\'' [0]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "om";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "or";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "os";
.   .   }
.   .   return error;
.   // '\''p'\'' [4,'\''t'\'']
.   case '\''p'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''_'\'']
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pa";
.   .   .   // '\''_'\'' [1,'\''A'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''A'\'' [1,'\''r'\'']
.   .   .   .   if (*p ++ == '\''A'\'') {
.   .   .   .   .   // '\''r'\'' [1,'\''a'\'']
.   .   .   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   .   .   // '\''a'\'' [1,'\''b'\'']
.   .   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   .   // '\''b'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''b'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "pa_Arab";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pl";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ps";
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pt";
.   .   }
.   .   return error;
.   // '\''r'\'' [5,'\''w'\'']
.   case '\''r'\'':
.   .   switch (*p ++) {
.   .   // '\''m'\'' [0]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rm";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rn";
.   .   .   return error;
.   .   // '\''o'\'' [1,'\''f'\'']
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ro";
.   .   .   // '\''f'\'' [0]
.   .   .   if (*p ++ == '\''f'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "rof";
.   .   .   }
.   .   .   return error;
.   .   // '\''u'\'' [0]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ru";
.   .   .   return error;
.   .   // '\''w'\'' [1,'\''k'\'']
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rw";
.   .   .   // '\''k'\'' [0]
.   .   .   if (*p ++ == '\''k'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "rwk";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''s'\'' [16,'\''w'\'']
.   case '\''s'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [2,'\''q'\'']
.   .   case '\''a'\'':
.   .   .   switch (*p ++) {
.   .   .   // '\''h'\'' [0]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "sah";
.   .   .   .   return error;
.   .   .   // '\''q'\'' [0]
.   .   .   case '\''q'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "saq";
.   .   .   }
.   .   .   return error;
.   .   // '\''b'\'' [1,'\''p'\'']
.   .   case '\''b'\'':
.   .   .   // '\''p'\'' [0]
.   .   .   if (*p ++ == '\''p'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "sbp";
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [2,'\''s'\'']
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "se";
.   .   .   switch (*p ++) {
.   .   .   // '\''h'\'' [0]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "seh";
.   .   .   .   return error;
.   .   .   // '\''s'\'' [0]
.   .   .   case '\''s'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ses";
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sg";
.   .   .   return error;
.   .   // '\''h'\'' [1,'\''i'\'']
.   .   case '\''h'\'':
.   .   .   // '\''i'\'' [1,'\''_'\'']
.   .   .   if (*p ++ == '\''i'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "shi";
.   .   .   .   // '\''_'\'' [1,'\''L'\'']
.   .   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   .   // '\''L'\'' [1,'\''a'\'']
.   .   .   .   .   if (*p ++ == '\''L'\'') {
.   .   .   .   .   .   // '\''a'\'' [1,'\''t'\'']
.   .   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   .   // '\''t'\'' [1,'\''n'\'']
.   .   .   .   .   .   .   if (*p ++ == '\''t'\'') {
.   .   .   .   .   .   .   .   // '\''n'\'' [0]
.   .   .   .   .   .   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   .   return "shi_Latn";
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''i'\'' [0]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "si";
.   .   .   return error;
.   .   // '\''k'\'' [0]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sk";
.   .   .   return error;
.   .   // '\''l'\'' [0]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sl";
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sn";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "so";
.   .   .   return error;
.   .   // '\''q'\'' [0]
.   .   case '\''q'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sq";
.   .   .   return error;
.   .   // '\''r'\'' [1,'\''_'\'']
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sr";
.   .   .   // '\''_'\'' [1,'\''L'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''L'\'' [1,'\''a'\'']
.   .   .   .   if (*p ++ == '\''L'\'') {
.   .   .   .   .   // '\''a'\'' [1,'\''t'\'']
.   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   // '\''t'\'' [1,'\''n'\'']
.   .   .   .   .   .   if (*p ++ == '\''t'\'') {
.   .   .   .   .   .   .   // '\''n'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "sr_Latn";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''s'\'' [1,'\''y'\'']
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ss";
.   .   .   // '\''y'\'' [0]
.   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ssy";
.   .   .   }
.   .   .   return error;
.   .   // '\''t'\'' [0]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "st";
.   .   .   return error;
.   .   // '\''v'\'' [0]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sv";
.   .   .   return error;
.   .   // '\''w'\'' [1,'\''c'\'']
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sw";
.   .   .   // '\''c'\'' [0]
.   .   .   if (*p ++ == '\''c'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "swc";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''t'\'' [11,'\''z'\'']
.   case '\''t'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [0]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ta";
.   .   .   return error;
.   .   // '\''e'\'' [1,'\''o'\'']
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "te";
.   .   .   // '\''o'\'' [0]
.   .   .   if (*p ++ == '\''o'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "teo";
.   .   .   }
.   .   .   return error;
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tg";
.   .   .   return error;
.   .   // '\''h'\'' [0]
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "th";
.   .   .   return error;
.   .   // '\''i'\'' [2,'\''g'\'']
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ti";
.   .   .   switch (*p ++) {
.   .   .   // '\''_'\'' [1,'\''E'\'']
.   .   .   case '\''_'\'':
.   .   .   .   // '\''E'\'' [1,'\''R'\'']
.   .   .   .   if (*p ++ == '\''E'\'') {
.   .   .   .   .   // '\''R'\'' [0]
.   .   .   .   .   if (*p ++ == '\''R'\'') {
.   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   return "ti_ER";
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   return error;
.   .   .   // '\''g'\'' [0]
.   .   .   case '\''g'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "tig";
.   .   .   }
.   .   .   return error;
.   .   // '\''n'\'' [0]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tn";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "to";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tr";
.   .   .   return error;
.   .   // '\''s'\'' [0]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ts";
.   .   .   return error;
.   .   // '\''w'\'' [1,'\''q'\'']
.   .   case '\''w'\'':
.   .   .   // '\''q'\'' [0]
.   .   .   if (*p ++ == '\''q'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "twq";
.   .   .   }
.   .   .   return error;
.   .   // '\''z'\'' [1,'\''m'\'']
.   .   case '\''z'\'':
.   .   .   // '\''m'\'' [0]
.   .   .   if (*p ++ == '\''m'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "tzm";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''u'\'' [4,'\''z'\'']
.   case '\''u'\'':
.   .   switch (*p ++) {
.   .   // '\''g'\'' [0]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ug";
.   .   .   return error;
.   .   // '\''k'\'' [0]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "uk";
.   .   .   return error;
.   .   // '\''r'\'' [0]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ur";
.   .   .   return error;
.   .   // '\''z'\'' [1,'\''_'\'']
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "uz";
.   .   .   // '\''_'\'' [2,'\''C'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   switch (*p ++) {
.   .   .   .   // '\''A'\'' [1,'\''r'\'']
.   .   .   .   case '\''A'\'':
.   .   .   .   .   // '\''r'\'' [1,'\''a'\'']
.   .   .   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   .   .   // '\''a'\'' [1,'\''b'\'']
.   .   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   .   // '\''b'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''b'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "uz_Arab";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   return error;
.   .   .   .   // '\''C'\'' [1,'\''y'\'']
.   .   .   .   case '\''C'\'':
.   .   .   .   .   // '\''y'\'' [1,'\''r'\'']
.   .   .   .   .   if (*p ++ == '\''y'\'') {
.   .   .   .   .   .   // '\''r'\'' [1,'\''l'\'']
.   .   .   .   .   .   if (*p ++ == '\''r'\'') {
.   .   .   .   .   .   .   // '\''l'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''l'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "uz_Cyrl";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''v'\'' [5,'\''u'\'']
.   case '\''v'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''i'\'']
.   .   case '\''a'\'':
.   .   .   // '\''i'\'' [1,'\''_'\'']
.   .   .   if (*p ++ == '\''i'\'') {
.   .   .   .   // '\''_'\'' [1,'\''L'\'']
.   .   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   .   // '\''L'\'' [1,'\''a'\'']
.   .   .   .   .   if (*p ++ == '\''L'\'') {
.   .   .   .   .   .   // '\''a'\'' [1,'\''t'\'']
.   .   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   .   // '\''t'\'' [1,'\''n'\'']
.   .   .   .   .   .   .   if (*p ++ == '\''t'\'') {
.   .   .   .   .   .   .   .   // '\''n'\'' [0]
.   .   .   .   .   .   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   .   return "vai_Latn";
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''e'\'' [0]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ve";
.   .   .   return error;
.   .   // '\''i'\'' [0]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "vi";
.   .   .   return error;
.   .   // '\''o'\'' [0]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "vo";
.   .   .   return error;
.   .   // '\''u'\'' [1,'\''n'\'']
.   .   case '\''u'\'':
.   .   .   // '\''n'\'' [0]
.   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "vun";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''w'\'' [1,'\''a'\'']
.   case '\''w'\'':
.   .   // '\''a'\'' [2,'\''l'\'']
.   .   if (*p ++ == '\''a'\'') {
.   .   .   switch (*p ++) {
.   .   .   // '\''e'\'' [0]
.   .   .   case '\''e'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "wae";
.   .   .   .   return error;
.   .   .   // '\''l'\'' [0]
.   .   .   case '\''l'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "wal";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''x'\'' [2,'\''o'\'']
.   case '\''x'\'':
.   .   switch (*p ++) {
.   .   // '\''h'\'' [0]
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "xh";
.   .   .   return error;
.   .   // '\''o'\'' [1,'\''g'\'']
.   .   case '\''o'\'':
.   .   .   // '\''g'\'' [0]
.   .   .   if (*p ++ == '\''g'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "xog";
.   .   .   }
.   .   }
.   .   return error;
.   // '\''y'\'' [2,'\''o'\'']
.   case '\''y'\'':
.   .   switch (*p ++) {
.   .   // '\''a'\'' [1,'\''v'\'']
.   .   case '\''a'\'':
.   .   .   // '\''v'\'' [0]
.   .   .   if (*p ++ == '\''v'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "yav";
.   .   .   }
.   .   .   return error;
.   .   // '\''o'\'' [1,'\''_'\'']
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "yo";
.   .   .   // '\''_'\'' [1,'\''B'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''B'\'' [1,'\''J'\'']
.   .   .   .   if (*p ++ == '\''B'\'') {
.   .   .   .   .   // '\''J'\'' [0]
.   .   .   .   .   if (*p ++ == '\''J'\'') {
.   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   return "yo_BJ";
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // '\''z'\'' [3,'\''u'\'']
.   case '\''z'\'':
.   .   switch (*p ++) {
.   .   // '\''g'\'' [1,'\''h'\'']
.   .   case '\''g'\'':
.   .   .   // '\''h'\'' [0]
.   .   .   if (*p ++ == '\''h'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "zgh";
.   .   .   }
.   .   .   return error;
.   .   // '\''h'\'' [1,'\''_'\'']
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "zh";
.   .   .   // '\''_'\'' [1,'\''H'\'']
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   // '\''H'\'' [1,'\''a'\'']
.   .   .   .   if (*p ++ == '\''H'\'') {
.   .   .   .   .   // '\''a'\'' [1,'\''n'\'']
.   .   .   .   .   if (*p ++ == '\''a'\'') {
.   .   .   .   .   .   // '\''n'\'' [1,'\''t'\'']
.   .   .   .   .   .   if (*p ++ == '\''n'\'') {
.   .   .   .   .   .   .   // '\''t'\'' [0]
.   .   .   .   .   .   .   if (*p ++ == '\''t'\'') {
.   .   .   .   .   .   .   .   if (*p == 0)
.   .   .   .   .   .   .   .   .   return "zh_Hant";
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   return error;
.   .   // '\''u'\'' [0]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "zu";
.   .   }
.   }
.   return error;'
) -L gen-wide-c-code-alphabets-ternary.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ ../src/trie --attrs --dots --gen=wide --output=c-code --trie=ternary < alphabets.txt'
../src/trie --attrs --dots --gen=wide --output=c-code --trie=ternary < alphabets.txt 2>&1 ||
echo 'command failed: ../src/trie --attrs --dots --gen=wide --output=c-code --trie=ternary < alphabets.txt'
)

