#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-wide-trie-base-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-wide-trie-base-array.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --gen=wide --output=trie --attrs --dots --trie=array "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a|trie
[1,'\''a'\''] {
.   '\''a'\'': "a"
}
$ print a b|trie
[2,'\''b'\''] {
.   '\''a'\'': "a"
.   '\''b'\'': "b"
}
$ print a b c|trie
[3,'\''c'\''] {
.   '\''a'\'': "a"
.   '\''b'\'': "b"
.   '\''c'\'': "c"
}
$ print a ab abc|trie
[1,'\''a'\''] {
.   '\''a'\'': "a" [1,'\''b'\''] {
.   .   '\''b'\'': "ab" [1,'\''c'\''] {
.   .   .   '\''c'\'': "abc"
.   .   }
.   }
}
$ print a ab ac|trie
[1,'\''a'\''] {
.   '\''a'\'': "a" [2,'\''c'\''] {
.   .   '\''b'\'': "ab"
.   .   '\''c'\'': "ac"
.   }
}
$ print a ab ac ad|trie
[1,'\''a'\''] {
.   '\''a'\'': "a" [3,'\''d'\''] {
.   .   '\''b'\'': "ab"
.   .   '\''c'\'': "ac"
.   .   '\''d'\'': "ad"
.   }
}
$ print a abd ac|trie
[1,'\''a'\''] {
.   '\''a'\'': "a" [2,'\''c'\''] {
.   .   '\''b'\'' [1,'\''d'\''] {
.   .   .   '\''d'\'': "abd"
.   .   }
.   .   '\''c'\'': "ac"
.   }
}
$ print a ab ac acd|trie
[1,'\''a'\''] {
.   '\''a'\'': "a" [2,'\''c'\''] {
.   .   '\''b'\'': "ab"
.   .   '\''c'\'': "ac" [1,'\''d'\''] {
.   .   .   '\''d'\'': "acd"
.   .   }
.   }
}
$ print a bb ba ccc|trie
[3,'\''c'\''] {
.   '\''a'\'': "a"
.   '\''b'\'' [2,'\''b'\''] {
.   .   '\''a'\'': "ba"
.   .   '\''b'\'': "bb"
.   }
.   '\''c'\'' [1,'\''c'\''] {
.   .   '\''c'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'': "ccc"
.   .   }
.   }
}
$ print a bb ccc|trie
[3,'\''c'\''] {
.   '\''a'\'': "a"
.   '\''b'\'' [1,'\''b'\''] {
.   .   '\''b'\'': "bb"
.   }
.   '\''c'\'' [1,'\''c'\''] {
.   .   '\''c'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'': "ccc"
.   .   }
.   }
}
$ print a bb ba ccc|trie
[3,'\''c'\''] {
.   '\''a'\'': "a"
.   '\''b'\'' [2,'\''b'\''] {
.   .   '\''a'\'': "ba"
.   .   '\''b'\'': "bb"
.   }
.   '\''c'\'' [1,'\''c'\''] {
.   .   '\''c'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'': "ccc"
.   .   }
.   }
}
$ print abc abd acde|trie
[1,'\''a'\''] {
.   '\''a'\'' [2,'\''c'\''] {
.   .   '\''b'\'' [2,'\''d'\''] {
.   .   .   '\''c'\'': "abc"
.   .   .   '\''d'\'': "abd"
.   .   }
.   .   '\''c'\'' [1,'\''d'\''] {
.   .   .   '\''d'\'' [1,'\''e'\''] {
.   .   .   .   '\''e'\'': "acde"
.   .   .   }
.   .   }
.   }
}
$ print abc abd acde ac|trie
[1,'\''a'\''] {
.   '\''a'\'' [2,'\''c'\''] {
.   .   '\''b'\'' [2,'\''d'\''] {
.   .   .   '\''c'\'': "abc"
.   .   .   '\''d'\'': "abd"
.   .   }
.   .   '\''c'\'': "ac" [1,'\''d'\''] {
.   .   .   '\''d'\'' [1,'\''e'\''] {
.   .   .   .   '\''e'\'': "acde"
.   .   .   }
.   .   }
.   }
}
$ print abc abd acde acfg|trie
[1,'\''a'\''] {
.   '\''a'\'' [2,'\''c'\''] {
.   .   '\''b'\'' [2,'\''d'\''] {
.   .   .   '\''c'\'': "abc"
.   .   .   '\''d'\'': "abd"
.   .   }
.   .   '\''c'\'' [2,'\''f'\''] {
.   .   .   '\''d'\'' [1,'\''e'\''] {
.   .   .   .   '\''e'\'': "acde"
.   .   .   }
.   .   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   .   '\''g'\'': "acfg"
.   .   .   }
.   .   }
.   }
}
$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\''] {
.   '\''c'\'' [2,'\''f'\''] {
.   .   '\''d'\'' [1,'\''e'\''] {
.   .   .   '\''e'\'': "cde"
.   .   }
.   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   '\''g'\'': "cfg" [1,'\''x'\''] {
.   .   .   .   '\''x'\'': "cfgx" [2,'\''z'\''] {
.   .   .   .   .   '\''y'\'': "cfgxy" [1,'\''z'\''] {
.   .   .   .   .   .   '\''z'\'': "cfgxyz"
.   .   .   .   .   }
.   .   .   .   .   '\''z'\'' [1,'\''z'\''] {
.   .   .   .   .   .   '\''z'\'' [1,'\''z'\''] {
.   .   .   .   .   .   .   '\''z'\'': "cfgxzzz"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\''] {
.   '\''c'\'' [2,'\''g'\''] {
.   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   '\''g'\'': "cfg" [1,'\''x'\''] {
.   .   .   .   '\''x'\'': "cfgx" [2,'\''z'\''] {
.   .   .   .   .   '\''y'\'': "cfgxy" [1,'\''z'\''] {
.   .   .   .   .   .   '\''z'\'': "cfgxyz"
.   .   .   .   .   }
.   .   .   .   .   '\''z'\'' [1,'\''z'\''] {
.   .   .   .   .   .   '\''z'\'' [1,'\''z'\''] {
.   .   .   .   .   .   .   '\''z'\'': "cfgxzzz"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   '\''g'\'' [1,'\''e'\''] {
.   .   .   '\''e'\'': "cge"
.   .   }
.   }
}
$ print a abcd abcdefg h hijk|trie
[2,'\''h'\''] {
.   '\''a'\'': "a" [1,'\''b'\''] {
.   .   '\''b'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'' [1,'\''d'\''] {
.   .   .   .   '\''d'\'': "abcd" [1,'\''e'\''] {
.   .   .   .   .   '\''e'\'' [1,'\''f'\''] {
.   .   .   .   .   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   .   .   .   .   '\''g'\'': "abcdefg"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   '\''h'\'': "h" [1,'\''i'\''] {
.   .   '\''i'\'' [1,'\''j'\''] {
.   .   .   '\''j'\'' [1,'\''k'\''] {
.   .   .   .   '\''k'\'': "hijk"
.   .   .   }
.   .   }
.   }
}
$ print a abcd abcdefg abcdxyz h hijk|trie
[2,'\''h'\''] {
.   '\''a'\'': "a" [1,'\''b'\''] {
.   .   '\''b'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'' [1,'\''d'\''] {
.   .   .   .   '\''d'\'': "abcd" [2,'\''x'\''] {
.   .   .   .   .   '\''e'\'' [1,'\''f'\''] {
.   .   .   .   .   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   .   .   .   .   '\''g'\'': "abcdefg"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   '\''x'\'' [1,'\''y'\''] {
.   .   .   .   .   .   '\''y'\'' [1,'\''z'\''] {
.   .   .   .   .   .   .   '\''z'\'': "abcdxyz"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   '\''h'\'': "h" [1,'\''i'\''] {
.   .   '\''i'\'' [1,'\''j'\''] {
.   .   .   '\''j'\'' [1,'\''k'\''] {
.   .   .   .   '\''k'\'': "hijk"
.   .   .   }
.   .   }
.   }
}
$ print a abcd abcdefg abcdxyz h hijk hlm|trie
[2,'\''h'\''] {
.   '\''a'\'': "a" [1,'\''b'\''] {
.   .   '\''b'\'' [1,'\''c'\''] {
.   .   .   '\''c'\'' [1,'\''d'\''] {
.   .   .   .   '\''d'\'': "abcd" [2,'\''x'\''] {
.   .   .   .   .   '\''e'\'' [1,'\''f'\''] {
.   .   .   .   .   .   '\''f'\'' [1,'\''g'\''] {
.   .   .   .   .   .   .   '\''g'\'': "abcdefg"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   '\''x'\'' [1,'\''y'\''] {
.   .   .   .   .   .   '\''y'\'' [1,'\''z'\''] {
.   .   .   .   .   .   .   '\''z'\'': "abcdxyz"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   '\''h'\'': "h" [2,'\''l'\''] {
.   .   '\''i'\'' [1,'\''j'\''] {
.   .   .   '\''j'\'' [1,'\''k'\''] {
.   .   .   .   '\''k'\'': "hijk"
.   .   .   }
.   .   }
.   .   '\''l'\'' [1,'\''m'\''] {
.   .   .   '\''m'\'': "hlm"
.   .   }
.   }
}'
) -L gen-wide-trie-base-array.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --gen=wide --output=trie --attrs --dots --trie=array "$@"; }'
trie() { ../src/trie --gen=wide --output=trie --attrs --dots --trie=array "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --gen=wide --output=trie --attrs --dots --trie=array "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a|trie'
print a|trie 2>&1 ||
echo 'command failed: print a|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a b c|trie'
print a b c|trie 2>&1 ||
echo 'command failed: print a b c|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab ac|trie'
print a ab ac|trie 2>&1 ||
echo 'command failed: print a ab ac|trie'

echo '$ print a ab ac ad|trie'
print a ab ac ad|trie 2>&1 ||
echo 'command failed: print a ab ac ad|trie'

echo '$ print a abd ac|trie'
print a abd ac|trie 2>&1 ||
echo 'command failed: print a abd ac|trie'

echo '$ print a ab ac acd|trie'
print a ab ac acd|trie 2>&1 ||
echo 'command failed: print a ab ac acd|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print a bb ccc|trie'
print a bb ccc|trie 2>&1 ||
echo 'command failed: print a bb ccc|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print abc abd acde|trie'
print abc abd acde|trie 2>&1 ||
echo 'command failed: print abc abd acde|trie'

echo '$ print abc abd acde ac|trie'
print abc abd acde ac|trie 2>&1 ||
echo 'command failed: print abc abd acde ac|trie'

echo '$ print abc abd acde acfg|trie'
print abc abd acde acfg|trie 2>&1 ||
echo 'command failed: print abc abd acde acfg|trie'

echo '$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print a abcd abcdefg h hijk|trie'
print a abcd abcdefg h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk|trie'
print a abcd abcdefg abcdxyz h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk hlm|trie'
print a abcd abcdefg abcdxyz h hijk hlm|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk hlm|trie'
)

