#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T print-obj-alphabets-ternary
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L print-obj-alphabets-ternary.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ ../src/trie --attrs --dots --output=object --trie=ternary < alphabets.txt
[25,'\''z'\'']
[8,'\''z'\''] {
.   .ch: '\''a'\''
.   .eq [0] {
.   .   .ch: '\''a'\''
.   .   .eq [0] {
.   .   .   .val: "aa"
.   .   }
.   .   .hi [0] {
.   .   .   .ch: '\''f'\''
.   .   .   .eq [0] {
.   .   .   .   .val: "af"
.   .   .   }
.   .   .   .hi [1,'\''q'\''] {
.   .   .   .   .ch: '\''g'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "agq"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   .hi [0] {
.   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "ak"
.   .   .   .   .   }
.   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "am"
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "ar"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [2,'\''t'\''] {
.   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "as"
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "asa"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "ast"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "az"
.   .   .   .   .   .   .   .   .   .   .hi [1,'\''C'\''] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''C'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''l'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "az_Cyrl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
.   .hi [9,'\''y'\''] {
.   .   .ch: '\''b'\''
.   .   .eq [1,'\''s'\''] {
.   .   .   .ch: '\''a'\''
.   .   .   .eq [0] {
.   .   .   .   .ch: '\''s'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "bas"
.   .   .   .   }
.   .   .   }
.   .   .   .hi [2,'\''z'\''] {
.   .   .   .   .ch: '\''e'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "be"
.   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "bem"
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "bez"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   .hi [0] {
.   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "bg"
.   .   .   .   .   }
.   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "bm"
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "bn"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "bo"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''x'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "br"
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "brx"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "bs"
.   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''C'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''C'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''l'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "bs_Cyrl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "byn"
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   .   .hi [5,'\''y'\''] {
.   .   .   .ch: '\''c'\''
.   .   .   .eq [0] {
.   .   .   .   .ch: '\''a'\''
.   .   .   .   .eq [0] {
.   .   .   .   .   .val: "ca"
.   .   .   .   }
.   .   .   .   .hi [1,'\''g'\''] {
.   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "cgg"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   .hi [1,'\''r'\''] {
.   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "chr"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "cs"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "cy"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   .   .hi [6,'\''z'\''] {
.   .   .   .   .ch: '\''d'\''
.   .   .   .   .eq [1,'\''v'\''] {
.   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .val: "da"
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "dav"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .val: "de"
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [1,'\''e'\''] {
.   .   .   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "dje"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "dua"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "dyo"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "dz"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   .   .hi [9,'\''w'\''] {
.   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .eq [1,'\''u'\''] {
.   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "ebu"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "ee"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "el"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "en"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "eo"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "es"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "et"
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "eu"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ewo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   .   .hi [7,'\''y'\''] {
.   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .val: "fa"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "ff"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [1,'\''l'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "fi"
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "fil"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "fo"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "fr"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "fur"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "fy"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   .   .hi [6,'\''v'\''] {
.   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .val: "ga"
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "gd"
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "gl"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [1,'\''w'\''] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "gsw"
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "gu"
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "guz"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "gv"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .hi [6,'\''y'\''] {
.   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .eq [1,'\''w'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .val: "ha"
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "haw"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "he"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "hi"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "hr"
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "hu"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "hy"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .hi [6,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .val: "ia"
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "id"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ig"
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ii"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "is"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "it"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .hi [3,'\''m'\''] {
.   .   .   .   .   .   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .val: "ja"
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "jgo"
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''c'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "jmc"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .hi [13,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .eq [2,'\''m'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ka"
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kab"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kam"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''e'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kde"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kea"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''q'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "khq"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ki"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''j'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kk"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''j'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kkj"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kln"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "km"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''k'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ko"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kok"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [3,'\''h'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ksb"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ksf"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ksh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "kw"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ky"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .hi [8,'\''v'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lag"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lg"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lkt"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ln"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lt"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lu"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "luo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "luy"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "lv"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .hi [12,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''s'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mas"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mer"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''e'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mfe"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mg"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mgh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mgo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mk"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ml"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mr"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ms"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mt"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "mua"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "my"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .hi [11,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''q'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "naq"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nb"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''d'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nd"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ne"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nmg"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''h'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nnh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nr"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nso"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''s'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nus"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "nyn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [3,'\''s'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "om"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "or"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "os"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [4,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''p'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "pa"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''A'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''A'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''b'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "pa_Arab"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "pl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ps"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "pt"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [5,'\''w'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "rm"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "rn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''f'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ro"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''f'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "rof"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ru"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''k'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "rw"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "rwk"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [16,'\''w'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [2,'\''q'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sah"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "saq"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''p'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''p'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sbp"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''s'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "se"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "seh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ses"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sg"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''i'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "shi"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''L'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''L'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "shi_Latn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "si"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sk"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "so"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sq"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sr"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''L'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''L'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sr_Latn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ss"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ssy"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "st"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sv"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''c'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "sw"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''c'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "swc"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [11,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ta"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "te"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "teo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "tg"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "th"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''g'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ti"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''E'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''R'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''E'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''R'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ti_ER"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "tig"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "tn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "to"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "tr"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''s'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ts"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''q'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''q'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "twq"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''m'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''m'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "tzm"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [4,'\''z'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ug"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''k'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "uk"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ur"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "uz"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''C'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''A'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''b'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''b'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "uz_Arab"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''y'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''C'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''r'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''l'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''r'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "uz_Cyrl"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [5,'\''u'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''i'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''L'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''L'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "vai_Latn"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "ve"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''i'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "vi"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "vo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "vun"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''w'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [2,'\''l'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''e'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "wae"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''l'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "wal"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''x'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "xh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''g'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "xog"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [2,'\''o'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''y'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''v'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''v'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "yav"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''o'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "yo"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''B'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''J'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''B'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''J'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "yo_BJ"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [3,'\''u'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''z'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''h'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''g'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "zgh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''_'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''h'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "zh"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [1,'\''H'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''_'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''a'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''H'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''n'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''a'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [1,'\''t'\''] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''n'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''t'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "zh_Hant"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .hi [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .ch: '\''u'\''
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .eq [0] {
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .val: "zu"
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   .   }
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}'
) -L print-obj-alphabets-ternary.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ ../src/trie --attrs --dots --output=object --trie=ternary < alphabets.txt'
../src/trie --attrs --dots --output=object --trie=ternary < alphabets.txt 2>&1 ||
echo 'command failed: ../src/trie --attrs --dots --output=object --trie=ternary < alphabets.txt'
)

