#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T print-obj-base
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L print-obj-base.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ printc() { LANG=C awk '\''{ printf("%c\n", strtonum("0x" $1)) }'\'' <<< "$1"; }
$ trie() { ../src/trie --trie=array --node=str "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a b|trie
{
    '\''a'\'': "a"
    '\''b'\'': "b"
}
$ print a aa b|trie
{
    '\''a'\'': "a" {
        '\''a'\'': "aa"
    }
    '\''b'\'': "b"
}
$ print a b bb|trie
{
    '\''a'\'': "a"
    '\''b'\'': "b" {
        '\''b'\'': "bb"
    }
}
$ print aa bb|trie
{
    '\''a'\'' {
        '\''a'\'': "aa"
    }
    '\''b'\'' {
        '\''b'\'': "bb"
    }
}
$ print a b bb cc ccc ddd dddd|trie
{
    '\''a'\'': "a"
    '\''b'\'': "b" {
        '\''b'\'': "bb"
    }
    '\''c'\'' {
        '\''c'\'': "cc" {
            '\''c'\'': "ccc"
        }
    }
    '\''d'\'' {
        '\''d'\'' {
            '\''d'\'': "ddd" {
                '\''d'\'': "dddd"
            }
        }
    }
}
$ print a ab abc|trie
{
    '\''a'\'': "a" {
        '\''b'\'': "ab" {
            '\''c'\'': "abc"
        }
    }
}
$ print a ab abc abcd|trie
{
    '\''a'\'': "a" {
        '\''b'\'': "ab" {
            '\''c'\'': "abc" {
                '\''d'\'': "abcd"
            }
        }
    }
}
$ print a ab abc abcd abc$'\''\xfa'\''|trie
{
    '\''a'\'': "a" {
        '\''b'\'': "ab" {
            '\''c'\'': "abc" {
                '\''d'\'': "abcd"
                '\''\xfa'\'': "abc\xfa"
            }
        }
    }
}
$ printc 1|trie
{
    '\''\x1'\'': "\x01"
}
$ printc ff|trie
{
    '\''\xff'\'': "\xff"
}
$ printc 22|trie
{
    '\''"'\'': "\""
}
$ printc 27|trie
{
    '\''\'\'''\'': "'\''"
}
$ trie() { ../src/trie --trie=ternary --node=str "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a b|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
        }
    }
}
$ print a aa b|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''a'\''
            .eq {
                .val: "aa"
            }
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
        }
    }
}
$ print a b bb|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
            .hi {
                .ch: '\''b'\''
                .eq {
                    .val: "bb"
                }
            }
        }
    }
}
$ print aa bb|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''a'\''
        .eq {
            .val: "aa"
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .eq {
                .val: "bb"
            }
        }
    }
}
$ print a b bb cc ccc ddd dddd|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
            .hi {
                .ch: '\''b'\''
                .eq {
                    .val: "bb"
                }
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .val: "cc"
                    .hi {
                        .ch: '\''c'\''
                        .eq {
                            .val: "ccc"
                        }
                    }
                }
            }
            .hi {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''d'\''
                    .eq {
                        .ch: '\''d'\''
                        .eq {
                            .val: "ddd"
                            .hi {
                                .ch: '\''d'\''
                                .eq {
                                    .val: "dddd"
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print a ab abc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
                .hi {
                    .ch: '\''c'\''
                    .eq {
                        .val: "abc"
                    }
                }
            }
        }
    }
}
$ print a ab abc abcd|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
                .hi {
                    .ch: '\''c'\''
                    .eq {
                        .val: "abc"
                        .hi {
                            .ch: '\''d'\''
                            .eq {
                                .val: "abcd"
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print a ab abc abcd abc$'\''\xfa'\''|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
                .hi {
                    .ch: '\''c'\''
                    .eq {
                        .val: "abc"
                        .hi {
                            .ch: '\''d'\''
                            .eq {
                                .val: "abcd"
                            }
                            .hi {
                                .ch: '\''\xfa'\''
                                .eq {
                                    .val: "abc\xfa"
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ printc 1|trie
{
    .ch: '\''\x1'\''
    .eq {
        .val: "\x01"
    }
}
$ printc ff|trie
{
    .ch: '\''\xff'\''
    .eq {
        .val: "\xff"
    }
}
$ printc 22|trie
{
    .ch: '\''"'\''
    .eq {
        .val: "\""
    }
}
$ printc 27|trie
{
    .ch: '\''\'\'''\''
    .eq {
        .val: "'\''"
    }
}
$ trie() { ../src/trie --node=str --output=trie --gen=compact --attrs "$@"; }
$ printc 22|trie --trie=array
[1,'\''"'\''] {
    "\"" [0,"",'\''"'\'',[0]]: "\""
}
$ printc 22|trie --trie=ternary
[1,'\''"'\''] {
    "\"" [0,"",'\''"'\'',[0]]: "\""
}
$ printc 27|trie --trie=array
[1,'\''\'\'''\''] {
    "'\''" [0,"",'\''\'\'''\'',[0]]: "'\''"
}
$ printc 27|trie --trie=ternary
[1,'\''\'\'''\''] {
    "'\''" [0,"",'\''\'\'''\'',[0]]: "'\''"
}'
) -L print-obj-base.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ printc() { LANG=C awk '\''{ printf("%c\n", strtonum("0x" $1)) }'\'' <<< "$1"; }'
printc() { LANG=C awk '{ printf("%c\n", strtonum("0x" $1)) }' <<< "$1"; } 2>&1 ||
echo 'command failed: printc() { LANG=C awk '\''{ printf("%c\n", strtonum("0x" $1)) }'\'' <<< "$1"; }'

echo '$ trie() { ../src/trie --trie=array --node=str "$@"; }'
trie() { ../src/trie --trie=array --node=str "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --trie=array --node=str "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a aa b|trie'
print a aa b|trie 2>&1 ||
echo 'command failed: print a aa b|trie'

echo '$ print a b bb|trie'
print a b bb|trie 2>&1 ||
echo 'command failed: print a b bb|trie'

echo '$ print aa bb|trie'
print aa bb|trie 2>&1 ||
echo 'command failed: print aa bb|trie'

echo '$ print a b bb cc ccc ddd dddd|trie'
print a b bb cc ccc ddd dddd|trie 2>&1 ||
echo 'command failed: print a b bb cc ccc ddd dddd|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab abc abcd|trie'
print a ab abc abcd|trie 2>&1 ||
echo 'command failed: print a ab abc abcd|trie'

echo '$ print a ab abc abcd abc$'\''\xfa'\''|trie'
print a ab abc abcd abc$'\xfa'|trie 2>&1 ||
echo 'command failed: print a ab abc abcd abc$'\''\xfa'\''|trie'

echo '$ printc 1|trie'
printc 1|trie 2>&1 ||
echo 'command failed: printc 1|trie'

echo '$ printc ff|trie'
printc ff|trie 2>&1 ||
echo 'command failed: printc ff|trie'

echo '$ printc 22|trie'
printc 22|trie 2>&1 ||
echo 'command failed: printc 22|trie'

echo '$ printc 27|trie'
printc 27|trie 2>&1 ||
echo 'command failed: printc 27|trie'

echo '$ trie() { ../src/trie --trie=ternary --node=str "$@"; }'
trie() { ../src/trie --trie=ternary --node=str "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --trie=ternary --node=str "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a aa b|trie'
print a aa b|trie 2>&1 ||
echo 'command failed: print a aa b|trie'

echo '$ print a b bb|trie'
print a b bb|trie 2>&1 ||
echo 'command failed: print a b bb|trie'

echo '$ print aa bb|trie'
print aa bb|trie 2>&1 ||
echo 'command failed: print aa bb|trie'

echo '$ print a b bb cc ccc ddd dddd|trie'
print a b bb cc ccc ddd dddd|trie 2>&1 ||
echo 'command failed: print a b bb cc ccc ddd dddd|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab abc abcd|trie'
print a ab abc abcd|trie 2>&1 ||
echo 'command failed: print a ab abc abcd|trie'

echo '$ print a ab abc abcd abc$'\''\xfa'\''|trie'
print a ab abc abcd abc$'\xfa'|trie 2>&1 ||
echo 'command failed: print a ab abc abcd abc$'\''\xfa'\''|trie'

echo '$ printc 1|trie'
printc 1|trie 2>&1 ||
echo 'command failed: printc 1|trie'

echo '$ printc ff|trie'
printc ff|trie 2>&1 ||
echo 'command failed: printc ff|trie'

echo '$ printc 22|trie'
printc 22|trie 2>&1 ||
echo 'command failed: printc 22|trie'

echo '$ printc 27|trie'
printc 27|trie 2>&1 ||
echo 'command failed: printc 27|trie'

echo '$ trie() { ../src/trie --node=str --output=trie --gen=compact --attrs "$@"; }'
trie() { ../src/trie --node=str --output=trie --gen=compact --attrs "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --node=str --output=trie --gen=compact --attrs "$@"; }'

echo '$ printc 22|trie --trie=array'
printc 22|trie --trie=array 2>&1 ||
echo 'command failed: printc 22|trie --trie=array'

echo '$ printc 22|trie --trie=ternary'
printc 22|trie --trie=ternary 2>&1 ||
echo 'command failed: printc 22|trie --trie=ternary'

echo '$ printc 27|trie --trie=array'
printc 27|trie --trie=array 2>&1 ||
echo 'command failed: printc 27|trie --trie=array'

echo '$ printc 27|trie --trie=ternary'
printc 27|trie --trie=ternary 2>&1 ||
echo 'command failed: printc 27|trie --trie=ternary'
)

