/*
 *   TabletToolbox, a toolbox application fot tablet PCs
 *   Copyright (C) 2010, Mariusz Adamski <mariusz.adamski@gmail.com>
 *
 *   This file is part of TabletToolbox.
 *
 *   TabletToolbox is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   TabletToolbox is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with TabletToolbox.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ui-gtk.h"
#include <gtk/gtk.h>
#include <string.h>

G_DEFINE_TYPE(UIGtk, ui_gtk, TTB_TYPE_UI)

static void
ui_gtk_init(UIGtk *self)
{
}

static void
ui_gtk_dispose(GObject *gobject)
{
	/* Chain up to the parent class */
	G_OBJECT_CLASS(ui_gtk_parent_class)->dispose(gobject);
}

static void
ui_gtk_finalize(GObject *gobject)
{
	/* Chain up to the parent class */
	G_OBJECT_CLASS(ui_gtk_parent_class)->finalize(gobject);
}

static void
cb_button_clicked(GtkWidget *widget, gpointer data)
{
	ttb_base_execute((gchar *) data);
	gtk_main_quit();
}

static void
ui_gtk_setup_window(UIGtk *self)
{
	GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	GtkWidget *hbox = gtk_hbox_new(TRUE, 1);
	gtk_container_add(GTK_CONTAINER(window), hbox);

	TTBBase *base = ttb_ui_get_base(TTB_UI(self));
	gint ent = TTB_BASE_GET_CLASS(base)->get_entries_n(base);
	GSList *list = TTB_BASE_GET_CLASS(base)->get_entries_list(base);
	while (list) {
		DesktopItem *item = list->data;
		GtkWidget *button = gtk_button_new_with_label(item->name);
		if ((item->icon) && (strlen(item->icon) != 0)) {
			GtkWidget *icon;
			icon = gtk_image_new_from_icon_name(item->icon,
		                                 GTK_ICON_SIZE_LARGE_TOOLBAR);
			gtk_button_set_image(GTK_BUTTON(button), icon);
		}
		gtk_container_add(GTK_CONTAINER(hbox), button);
		gtk_widget_show(button);
		g_signal_connect(button, "clicked",
		                 G_CALLBACK(cb_button_clicked),
		                 item->exec);
		list = g_slist_next(list);
	}

	gtk_window_set_keep_above(GTK_WINDOW(window), TRUE);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
	gtk_window_set_title(GTK_WINDOW(window), "TTB");
	gtk_widget_show(hbox);
	gtk_widget_show(window);
	g_signal_connect_swapped(G_OBJECT(window), "destroy",
	                         G_CALLBACK(gtk_main_quit), NULL);
}

gboolean
ui_gtk_exec(TTBUI *self, int argc, char **argv)
{
	g_return_if_fail(UI_IS_GTK(self));

	gtk_init(&argc, &argv);

	ui_gtk_setup_window(UI_GTK(self));

	gtk_main();

	return 1;
}

static void
ui_gtk_class_init(UIGtkClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
	GParamSpec *pspec;
	
	gobject_class->dispose  = ui_gtk_dispose;
	gobject_class->finalize = ui_gtk_finalize;

	TTB_UI_CLASS(klass)->exec = ui_gtk_exec;
}

