<?
# pg_load.php
# Written by Aaron Dummer <aaron@xtratyme.com>.
#
# Version 1.0 - initial release
#
# This script loads ulog-acctd accounting data into a PostgreSQL table for advanced data reporting.
# It could be easily modified to use MySQL, but the transaction feature would only work with InnoDB tables.
#
# Create the accounting table in PostreSQL, give yourself insert privileges, update the global variables, and you're all set!
#
# Please email me with any comments, bugs, feature requests, etc.
#
# CREATE TABLE "accounting" (
#   "seq" BIGSERIAL, 
#   "hostname" VARCHAR(50), 
#   "timestamp" INTEGER, 
#   "protocol" INTEGER, 
#   "src_ip" VARCHAR(15), 
#   "src_port" INTEGER, 
#   "dst_ip" VARCHAR(15), 
#   "dst_port" INTEGER, 
#   "packets" INTEGER, 
#   "bytes" INTEGER, 
#   "mac" TEXT, 
#   PRIMARY KEY("seq")
# ) WITHOUT OIDS;

# Declare some global variables
$main_file = "/var/log/ulog-acctd/account.log";
$archive_file = "/var/log/ulog-acctd/archive.log";
$email_address = "user@domain.extension";
$email_headers = "";
$db_host = "localhost";
$db_database = "ulog";
$db_username = "ulog";
$db_password = "secret"

# Find out the process id
$pid = @file("/var/run/ulog-acctd.pid");

# It's not running, try to start it up and alert someone that it was down
if(!$pid) {
	exec("/etc/init.d/ulog-acctd start");
	mail($email_address, "ulog-acctd is not running", "", $email_headers);
} else {
	# Take off the trailing newline
	$pid = str_replace("\n", "", $pid[0]);

	# Tell it to stop writing data
	exec("/bin/kill -TSTP $pid");

	# Move the current data over for processing
	exec("/bin/cat $main_file >> $archive_file");

	# Clear out the current file
	unlink($main_file);
	touch($main_file);

	# Tell it to continue writing data
	exec("/bin/kill -CONT $pid");

	# Read in the datafile and try to get a database connection
	$data = file($archive_file);
	$db = pg_pconnect("host=$db_host user=$db_user password=$db_password dbname=$db_database");

	# The database connection worked, insert the data
	if($db) {
		pg_query($db, "BEGIN");
		for($i=0; $i<count($data); $i++) {
			$row = explode("\t", $data[$i]);
			$row[9] = str_replace("\n", "", $row[9]);

			$insert = pg_query($db, "INSERT INTO accounting (hostname, timestamp, protocol, src_ip, src_port, dst_ip, dst_port, packets, bytes, mac) VALUES('$row[0]', '$row[1]', '$row[2]', '$row[3]', '$row[4]', '$row[5]', '$row[6]', '$row[7]', '$row[8]', '$row[9]')");

			if(!$insert) {
				$insert_fail = 1;
				break;
			}
		}
		if($insert_fail == 1) {
			# One of the inserts failed, give up and report the error
			pg_query($db, "ROLLBACK");
			mail($email_address, "ulog-acctd database inserts failed", "", $email_headers);
		} else {
			# Reporting was successful, clear out the archive
			unlink($archive_file);

			pg_query($db, "COMMIT");
		}
	}
}
?>
