/*
  ulog-acctd

  (C) 2002 Hilko Bengen

  $Id: config.h,v 1.12 2003/08/26 13:34:29 bengen Exp $
*/

struct config
{
  char *acct_file;
  char *dump_file;
  char *dbg_file;
  char *pid_file;
  char *acct_format;
  char *date_format;
  int flush; /* in seconds */
  int fdelay; /* in seconds */
  int err_delay; /* how many cycles to delay on error ? */
  int mcast_group;
  int output, debug; /* bitmasks */
  size_t so_rcvbuf;
  unsigned int hash_table_size;
  int logger_nice_value;
  char empty_iface[32];
  char empty_prefix[32];
};

extern struct config *cfg; 

extern int acct_file;
extern int dump_file;
extern int dbg_file;

extern char *fname;

#define DEFAULT_CONFFILE "/etc/ulog-acctd.conf"
#define DEFAULT_DATEFORMAT "%d/%m/%y %H:%M:%S"

/* default settings for naccttab */
#define DEFAULT_FLUSH 300
#define DEFAULT_ERR_DELAY 3
#define DEFAULT_FDELAY 60

#define FORCE_STAT_TIME 5

#define VERSION "0.4.0"

/* config.c */
struct config *read_config(char *fname);
