/*
 * Copyright (C) 2000 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "unac.h"

static char* buffer;
static int buffer_length;

MODULE = Text::Unaccent PACKAGE = Text::Unaccent PREFIX = perl_

BOOT:
	buffer = 0;
	buffer_length = 0;

SV*
perl_unac_string(charset,in)
	char* charset
	char* in
	PROTOTYPE: $$
	CODE:
		STRLEN in_length;
		in_length = SvCUR(ST(1));
		if(unac_string(charset,
			       in, in_length,
			       &buffer, &buffer_length) == 0) {
	          RETVAL = newSVpv(buffer, buffer_length);
		} else {
		  perror("unac_string");
		  RETVAL = &PL_sv_undef;
		}
         OUTPUT:
		RETVAL

SV*
perl_unac_string_utf16(in)
	char* in
	PROTOTYPE: $
	CODE:
		STRLEN in_length;
		in_length = SvCUR(ST(0));
		if(unac_string_utf16(in, in_length,
				     &buffer, &buffer_length) == 0) {
	          RETVAL = newSVpv(buffer, buffer_length);
		} else {
		  perror("unac_string_utf16");
		  RETVAL = &PL_sv_undef;
		}
	OUTPUT:
		RETVAL

SV*
perl_unac_version()
	CODE:
	        RETVAL = newSVpv((char*)unac_version(), 0);
	OUTPUT:
		RETVAL
