# $Id: usertools.ph,v 1.6 2003/05/22 23:09:47 visick Exp $
#
# usertools.ph - header for functions used by UserTools
#
# Copyright (C) 2002 Steven Barrus
# Copyright (C) 2002 Dana Dahlstrom
# Copyright (C) 2002 Robert Ricci
# Copyright (C) 2002 Spencer Visick
#
# See the AUTHORS file for contact info
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use Net::LDAP qw(:all);
use Term::ReadKey;
use Crypt::Cracklib;
use Crypt::PasswdMD5;

read_config();

sub read_config {
  my $user = (getpwuid($>))[0];
  %config = (port => 389, 
             scope => "subtree",
             idle_timelimit => 0,
             default_shell => "ask",
             password_hash => "crypt",
             homedir_command => "mkdir",
             version => 2);
  
  my $rc = parse_config("/etc/usertools.conf");
  $rc &= parse_config("$ENV{HOME}/.usertoolsrc");
  if ($rc == 1) {
    warn "No config file found\n";
    exit 1;
  }

  $config{userbase} = "ou=People,$config{base}" if !$config{userbase};
  $config{groupbase} = "ou=Group,$config{base}" if !$config{groupbase};
  $config{binddn} = "uid=$user,ou=People,$config{base}" if !$config{binddn};
}

sub parse_config { 
  my $conf = shift;
  my @opts = ("host", "port", "base", "userbase", "groupbase", "sslversion",  
              "password_hash", "binddn", "idle_timelimit", "default_shell", 
              "group_attribute", "user_attribute", "group_objectclass", 
              "user_objectclass", "password_attribute", "required_attribute", 
              "default_gid", "homedir_command", "version", "cafile");

  if (-r $conf){
    open (CONF, $conf) || return 1;
    while (<CONF>){
      foreach $opt (@opts) {
        if (/^$opt/){
          @option = split();
          shift(@option);
          $config{$opt} = shift(@option);
          for(@option){
            $config{$opt} = $config{$opt} . " " . $_;
          }
        }
      }
    }
    return 0;
  }

  return 1;
}

sub ldap_connect {

  if (@_) {
    my ($binddn, $base) = @_;
    $config{binddn} = $binddn;
    $config{base} = $base;
  }

  die "No server hostname specified.\n" if !$config{host};
  
  my $ldap;
  my $pw;
  my $mesg;
  
  $ldap = Net::LDAP->new($config{host}, version => $config{version}) 
          or die "$@";

  if (defined($config{sslversion})){
    if (-e $config{cafile}){
      $mesg = $ldap->start_tls(verify => 'require',
                               sslversion => "$config{sslversion}",
                               cafile => "$config{cafile}");
      $mesg->code && die "Failed to start TLS: ", $mesg->error;
    }else{
      die "CA certificate $config{cafile} does not exist.\n"
    }
  }

  do {
    $pw = read_pass();
    $mesg = $ldap->bind($config{binddn}, password => $pw);

    if ($mesg->code) {
      print "Could't connect to $config{host}. ", $mesg->error, "\n"; 
      if ($mesg->code != LDAP_INVALID_CREDENTIALS) {
        exit(1);
      }
    }
  } while ($mesg->code == LDAP_INVALID_CREDENTIALS);
    
  return $ldap;
}

sub ldap_connect_anon {
  
  my $ldap = Net::LDAP->new($config{host}, version => $config{version}) or die "$@";
  
  if (@_) {
    my ($base) = @_;
    $config{base} = $base;
  }
  my $mesg = $ldap->bind();
    die "Could't connect to $config{host}.\n", $mesg->error if $mesg->code;

  return $ldap;
}

sub read_pass {
  my $pw;
  print "Password: ";
  ReadMode 2;
  chomp($pw = <STDIN>);
  ReadMode 0;
  print "\n";
  return $pw;
}

sub get_new_pass {
  my $gotpasswd = 0;

  while (1) {
    print "New ";
    $password = read_pass();

    $reason = fascist_check($password, "/usr/local/share/cracklib/pw_dict");
    unless ($reason eq "ok") {
      print "BAD PASSWORD: $reason\n";
      next;
    }
    
    print "Retype New ";
    $password2 = read_pass();

    if ($password eq $password2) {
      return(enc_passwd($password));
    } else {
      print "Passwords don't match.\n";
    }
  }
}

#generates a 'random' password
sub gen_pass{
  my @chars = ('a' .. 'k','m' .. 'z',2..9);
  my $pass = "";
  for (1 .. 8) {
    $pass .= $chars[rand @chars];
  }
  return $pass;
}

sub enc_passwd {
  my $password = shift;
  my @chars = ( 'A' .. 'Z', 'a' .. 'z', '0' .. '9', '/', '.' );
  my $salt = "";
  if ($config{password_hash} eq "md5") {
    for (1..8) {
      $salt .= $chars[rand @chars];
    }
    return ("{md5}" . unix_md5_crypt($password,$salt));
  }
  if ($config{password_hash} eq "plain") {
    return ($password,$salt);
  }
  $salt = $chars[rand @chars] . $chars[rand @chars];
  return ("{crypt}" . crypt($password,$salt));
}

1;
