/* Vgrid - Virtual grid program for radiology
   Copyright (C) 2020, 2021 Sonia Diaz Pacheco.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#define _FILE_OFFSET_BITS 64

#include <cstdio>
#include <cstring>
#include <string>
#include <vector>

#include "vgrid.h"
#include "matrix.h"


int self_test1()			// basic tests with simple inputs
  {
  int tests = 0, errors = 0;				// counters

  tests += 3;
  {
  const Matrix magic5 = Matrix::magic5();
  const double array_m1[25] = { 17,  7,  7,  8, 14,
                                 6,  7,  8, 14, 15,
                                 6, 10, 13, 16, 16,
                                10, 12, 18, 19,  9,
                                11, 12, 18,  9,  3 };
  const Matrix m1( 5, 5, array_m1 );
  const double array_m2[25] = {  7,  8, 14, 13, 14,
                                10, 12, 13, 13, 14,
                                12, 12, 13, 13, 14,
                                11, 12, 12, 13, 14,
                                12, 12, 12, 13, 19 };
  const Matrix m2( 5, 5, array_m2 );
  if( magic5.median_filter( 0 ) != magic5 )
    {
    ++errors;
    if( verbosity >= 0 )
      { std::fputs( "Error: median_filter( radius = 0 ) failed.\n", stdout );
        ( magic5.median_filter( 0 ) - magic5 ).print(); }
    }
  if( magic5.median_filter( 1 ) != m1 )
    {
    ++errors;
    if( verbosity >= 0 )
      { std::fputs( "Error: median_filter( radius = 1 ) failed.\n", stdout );
        ( magic5.median_filter( 1 ) - m1 ).print(); }
    }
  if( magic5.median_filter( 2 ) != m2 )
    {
    ++errors;
    if( verbosity >= 0 )
      { std::fputs( "Error: median_filter( radius = 2 ) failed.\n", stdout );
        ( magic5.median_filter( 2 ) - m2 ).print(); }
    }
  }

  if( verbosity >= 0 )
    std::printf( "Results of basic tests: %2d tests run  %2d tests failed\n",
                 tests, errors );
  return errors != 0;
  }


// full tests with real image input
int self_test2( const Matrix & image, const int maxval,
                const char * const program_name )
  {
  int tests = 0, errors = 0;				// counters
  const double max_elem = image.max();
  if( max_elem > maxval )
    {
    if( verbosity >= 0 )
      std::fprintf( stderr, "%s: image.max (%g) > maxval (%d).\n",
                    program_name, max_elem, maxval );
    return 2;
    }

  ++tests;
  if( image.median_filter( 0 ) != image )
    {
    ++errors;
    if( verbosity >= 0 )
      { std::fputs( "Error: median_filter( radius = 0 ) failed.\n", stdout );
        ( image.median_filter( 0 ) - image ).print(); }
    }

  if( verbosity >= 0 )
    std::printf( "%2d tests run  %2d tests failed\n", tests, errors );
  return errors != 0;
  }
