/*   This is part of um-ViewOS
 *   The user-mode implementation of OSVIEW -- A Process with a View
 *
 *   um_mov_service user command
 *   
 *   Copyright 2005 Renzo Davoli University of Bologna - Italy
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *   $Id: um_mov_service.c,v 1.2 2005/10/01 10:53:10 rd235 Exp $
 *
 */   
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>

#define UM_NONE 0xff

void usage()
{
	fprintf(stderr, "Usage:\n\tum_mov_service [-p #] [-c hex] newposition\n"
			"\t -p or -c must be specified (but not both)\n");
}

main(int argc, char *argv[])
{
	int c;
	int position=0, newposition=0;
	int code=UM_NONE;
	while (1) {
		int option_index = 0;
		static struct option long_options[] = {
			{"position", 1, 0, 'p'},
			{"code", 1, 0, 'c'},
			{0,0,0,0}
		};
		c=getopt_long(argc,argv,"p:c:",long_options,&option_index);
		if (c == -1) break;
		switch (c) {
			case 'p':
				position=atoi(optarg);
				break;
			case 'c':
				sscanf(optarg,"%x",&code);
				code = code &0xff;
				break;
		}
	}
	if (argc - optind != 1 || (position == 0 && code == UM_NONE) ||
			(position != 0 && code != UM_NONE))
		usage();
	else {
		newposition=atoi(argv[optind]);
		if (position > 0) {
			char lsbuf[256];
			int n;
			if ((n=um_list_service(lsbuf,256)) < 0) {
				perror("um_mov_service");
				exit(-1);
			}
			if (position > n) 
				position=n;
			code=lsbuf[position-1];
			
		}
		if (um_mov_service(code,newposition) < 0) {
			perror("um_mov_service");
			exit(-1);
		}
		else
			exit(0);
	}
}

