/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHDLG_H
#define __CHDLG_H

#include <qdialog.h>

class QLineEdit;
class QListBoxItem;
class ChannelList;

class ChannelsDialog: public QDialog
{
	Q_OBJECT
	private:
		QLineEdit *le_channel;

	signals:
		void joinChannel(const QString &);
		
	private slots:
		void joinButtonClicked();
		void doubleClicked(QListBoxItem *item);
	
	public:
		ChannelsDialog(QWidget *parent, ChannelList *chlist);
		~ChannelsDialog();

};

#endif

