/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHATLINEHIST_H
#define __CHATLINEHIST_H

#include <qwidget.h>

class QListBox;
class QListBoxItem;
class QPushButton;
class QStringList;

class ChatLineHistory: public QWidget
{
	Q_OBJECT
	
	private:
		QListBox *hlb;
		QPushButton *b_use;
		
	signals:
		void clicked(const QString &);
		
	private slots:
		void clicked(QListBoxItem *);
		void clickedUseButton();
		
	public:
		ChatLineHistory(QWidget *parent, const QStringList &hist);
		~ChatLineHistory();
};

#endif

