/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CHATTAB_H
#define __CHATTAB_H

#include "channel.h"
#include <qtabwidget.h>
#include <qmap.h>

class QAction;

class ChatTab: public QTabWidget
{
	Q_OBJECT
		
	private:
		typedef QMap<QString, Channel *> ChannelMap;

		ChannelMap cmap;
		Channel *prevdel;

		bool del(const QString &name);
		inline Channel *currentPage()
		{ 
			return static_cast<Channel *>(QTabWidget::currentPage());
		}

	public slots:
		void clearCurrent();
	
	private slots:
		void tabChanged(QWidget *widget);
	
	signals:
		void leave(const QString &channel);

	public:
		ChatTab(QWidget *parent);
		~ChatTab();
		bool isPrivate(const QString &name);
		bool isPrivate() { return isPrivate(current()); }
		bool addChannel(const QString &name, const QString &topic);
		bool delChannel(const QString &name);
		bool addPrivate(const QString &name);
		bool delPrivate(const QString &name);
		QString getTopic(const QString &name);
		bool setTopic(const QString &name, const QString &topic);
		bool write(const QString &channel, const QString &str, QColor color);
		bool exists(const QString &name) const { return cmap.contains(name); }
		QString current() { return currentPage()->name(); }
		QString channelsList();
};

#endif

