/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "chlist.h"
#include <iostream>

ChannelList::ChannelList(): QStringList()/*{{{*/
{
}/*}}}*/

ChannelList::~ChannelList()/*{{{*/
{
}/*}}}*/

void ChannelList::add(const QString &name)/*{{{*/
{
	if (name.isEmpty())
		return;
	QString tmp  = name[0] == '#' ? name : "#" + name; //append "#" at the beginning if neede
	if (find(tmp) == end())
		append (tmp);
}/*}}}*/

void ChannelList::add(const QStringList &list)/*{{{*/
{
	for (QStringList::ConstIterator it = list.constBegin(); it != list.constEnd(); ++it)
		add(*it);
}/*}}}*/

bool ChannelList::del(const QString &name)/*{{{*/
{
	return remove(name)>0;
}/*}}}*/

QStringList ChannelList::list()/*{{{*/
{
	return *this;
}/*}}}*/


