/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include <qapplication.h>
#include <qmessagebox.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <unistd.h>
#include <sys/types.h>
#include "settings.h"
#include "appwin.h"
#include "global.h"
#include "icons.h"

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	
	Settings settings;
	settings.load();
	Icons::setTheme(settings.getIconThemeName());

	//
	// setup translation
	QTranslator trn(0);
	if (trn.load(QString("vyqchat_") + QTextCodec::locale(), QString(DATADIR) + "/tr"))
		app.installTranslator(&trn);
	
	MainWindow win(NULL, &settings);
	app.setMainWidget(&win);
	
	//
	// hide main window if it was hidden last time; this is only applied
	// when using systray docking
	if (settings.getUseSystray())
		win.setShown(settings.getWindowVisible());
	else
		win.show();

	return app.exec();
}

