/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "massmsgwin.h"
#include <qlayout.h>
#include <qlistbox.h>
#include <qhbox.h>
#include <qtextedit.h>
#include <qpushbutton.h>

MassMessageWindow::MassMessageWindow(const QString &ownnick, const QStringList &nicks): QWidget(NULL)/*{{{*/
{
	setWFlags(Qt::WDestructiveClose | getWFlags());
	setCaption("Mass Message");
	resize(340, 180);

	QBoxLayout *l1 = new QVBoxLayout(this);

	QHBox *box1 = new QHBox(this);
	l1->addWidget(box1);
	
	msg = new QTextEdit(box1);
	msg->setTextFormat(PlainText);
	msg->setFocus();

	//
	// create listbox with all nicks; highlight all except for user's nick
	nicklist = new QListBox(box1);
	nicklist->setSelectionMode(QListBox::Multi);
	nicklist->setFixedWidth(100);
	nicklist->setFocusPolicy(NoFocus);
	nicklist->insertStringList(nicks);
	nicklist->selectAll(true);
	nicklist->setSelected(nicks.findIndex(ownnick), false);
	nicklist->sort();
	
	QBoxLayout *bl = new QHBoxLayout(l1);
	b_send = new QPushButton("&Send", this);
	b_ok = new QPushButton("Close", this);
	bl->addWidget(b_send);
	bl->addStretch(20);
	bl->addWidget(b_ok);
 		
	setMinimumSize(280, 120);

	connect(b_send, SIGNAL(clicked()), this, SLOT(sendPressed()));
	connect(b_ok, SIGNAL(clicked()), this, SLOT(close()));
}/*}}}*/

MassMessageWindow::~MassMessageWindow()/*{{{*/
{
}/*}}}*/

/*-----------------------------------------------------------------------------------------------------
 * 
 *                                            S L O T S
 *
 -----------------------------------------------------------------------------------------------------*/
void MassMessageWindow::sendPressed()/*{{{*/
{
	if (!msg->text().isEmpty())
	{
		QStringList nicks;
		
		//
		// create a list of selected nicks
		for (int i=0; i<nicklist->count(); i++)
			if (nicklist->isSelected(i))
				nicks.append(nicklist->text(i));
		emit send(nicks, msg->text());
	}
	close();
}/*}}}*/

