/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "msgsndwin.h"
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlayout.h>

MessageSndWindow::MessageSndWindow(const QString &to): QWidget(NULL)/*{{{*/
{
	this->to = to;
	
	setWFlags(Qt::WDestructiveClose | getWFlags());
	setCaption(QString("Message to: ") + to);
	QBoxLayout *l1 = new QVBoxLayout(this);
	msg = new QTextEdit(this);
	msg->setTextFormat(PlainText);
	l1->addWidget(msg);
	
	QBoxLayout *bl = new QHBoxLayout(l1);
	b_send = new QPushButton("&Send", this);
	b_ok = new QPushButton("Close", this);
	bl->addWidget(b_send);
	bl->addStretch(20);
	bl->addWidget(b_ok);
	
	setMinimumSize(280, 120);

	connect(b_send, SIGNAL(clicked()), this, SLOT(sendPressed()));
	connect(b_ok, SIGNAL(clicked()), this, SLOT(close()));
}/*}}}*/

MessageSndWindow::~MessageSndWindow()/*{{{*/
{
}/*}}}*/

/*-----------------------------------------------------------------------------------------------------
 * 
 *                                            S L O T S
 *
 -----------------------------------------------------------------------------------------------------*/
void MessageSndWindow::sendPressed()/*{{{*/
{
	if (!msg->text().isEmpty())
		emit send(to, msg->text());
	close();
}/*}}}*/

