/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "scripting.h"
#include <qdatetime.h>
#include <qstring.h>
#include <stdlib.h>
#include <qprocess.h>

bool Scripting::run(const QString &fname, const QStringList &env)/*{{{*/
{
	QProcess *proc = new QProcess(fname, NULL);
	return proc->start(&const_cast<QStringList &>(env));
}/*}}}*/

void Scripting::executeChatline(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=C");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

void Scripting::executeMessage(const QString &fname, const QDateTime &date, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=M");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

void Scripting::executeJoin(const QString &fname, const QDateTime &date, const QString &channel, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=J");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeLeave(const QString &fname, const QDateTime &date, const QString &channel, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=L");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeBeep(const QString &fname, const QDateTime &date, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=B");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeInfoRequest(const QString &fname, const QDateTime &date, const QString &from)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=I");
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	run(fname, env);
}/*}}}*/

void Scripting::executeRegexpMatch(const QString &fname, const QDateTime &date, const QString &channel, const QString &from, const QString &text)/*{{{*/
{
	QStringList env;
	env.push_back("EVENT=R");
	env.push_back("CHANNEL=" + channel);
	env.push_back("TIME=" + date.toString("hh:mm"));
	env.push_back("DATE=" + date.toString());
	env.push_back("FROM=" + from);
	env.push_back("TEXT=" + text);
	run(fname, env);
}/*}}}*/

