/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SOUND_H
#define __SOUND_H

#include <qmemarray.h>
#include <qstringlist.h>
#include "vyevent.h"

#ifdef HAVE_SNDFILE

#	ifdef HAVE_LIBAO
#	include <ao/ao.h>
#	endif

#	ifdef HAVE_ARTS
#	include <artsc.h>
#	endif

#include <sndfile.h>
#endif

class QString;
class Settings;
class SoundSystem;

class Sound
{	
	public:
		enum SoundType { NoSound = 0, PCSpeaker, LibAo, Arts, Command };
	
	private:
		static SoundSystem *sndsys;
		static SoundType sndtype;
		
	public:
		bool reload_samples(Settings &settings);
		static bool init(Settings *settings);
		static void close();
		static const QString& Sound::error();
		static void play(VyEvent evt);
};

class SoundSystem
{
	protected:
		QString errstr;
		QByteArray *sample[EventDummy];
#	ifdef HAVE_SNDFILE
		SF_INFO sfinf[EventDummy];
#	endif
		virtual bool reload_samples(Settings &settings);
		
	public:
		SoundSystem();
		virtual ~SoundSystem();
		virtual bool init() { return true; };
		virtual void close() {};
		virtual void play(VyEvent evt) {};
		friend class Sound;
};

class SoundPCSpeaker: public SoundSystem
{
	public:
		virtual bool init();
		virtual void close();
		virtual void play(VyEvent evt);
};

class SoundArts: public SoundSystem
{
	public:
		virtual bool init();
		virtual void close();
		virtual void play(VyEvent evt);
};

class SoundLibAo: public SoundSystem
{
	private:
		int drv;
		
	public:
		virtual bool init();
		virtual void close();
		virtual void play(VyEvent evt);
};

class SoundCommand: public SoundSystem
{
	private:
		//
		// lists of command and arguments
		QStringList arg[EventDummy];
		virtual bool reload_samples(Settings &settings);
		
	public:
		virtual bool init();
		virtual void play(VyEvent evt);
};

#endif

