/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "topicwin.h"
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>


TopicWin::TopicWin(QWidget *parent, const QString &channel, const QString &topic): QDialog(parent, NULL, true)/*{{{*/
{
	setCaption(tr("Set topic for channel") + " " + (this->channel=channel));
	
	le_topic = new QLineEdit(topic, this);
	le_topic->setMinimumWidth(320);
	le_topic->selectAll();
	
	b_ok = new QPushButton(tr("OK"), this);
	
	QBoxLayout *l1 = new QHBoxLayout(this, 0, 5);
	l1->addWidget(le_topic);
	
	l1->addStretch(20);
	l1->addWidget(b_ok);
	connect(b_ok, SIGNAL(clicked()), this, SLOT(accept()));
}/*}}}*/

TopicWin::~TopicWin()/*{{{*/
{
}/*}}}*/

void TopicWin::accept()/*{{{*/
{
	emit newTopic(channel, le_topic->text());
	QDialog::accept();
}/*}}}*/

