/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Game.cc

    @see Game.hh
    @see Game_Elements_Accessor.hh */

#include "Game_Elements_Accessor.hh"
#include "Game.hh"
#include "gameplay_variables.hh"

namespace XBobble
{

Game_Elements_Accessor::Game_Elements_Accessor(Game& arg)
 : game(arg)
{
}

Launcher&
Game_Elements_Accessor::get_launcher()
{
	return game.launcher;
}

Chooser&
Game_Elements_Accessor::get_chooser()
{
	return game.chooser;
}

Timeout_Meter&
Game_Elements_Accessor::get_timeout_meter()
{
	return game.timeout_meter;
}

Grid_Shaker&
Game_Elements_Accessor::get_grid_shaker()
{
	return game.grid_shaker;
}

Ambient_Effects_Manager&
Game_Elements_Accessor::get_ambient_effects_manager()
{
	return game.ambient_effects_manager;
}

Launched_Ball_Manager&
Game_Elements_Accessor::get_launched_ball_manager()
{
	return game.launched_ball_manager;
}

Popped_Balls_Manager&
Game_Elements_Accessor::get_popped_balls_manager()
{
	return game.popped_balls_manager;
}

Grid&
Game_Elements_Accessor::get_grid()
{
	return game.grid;
}

const Launcher&
Game_Elements_Accessor::get_launcher() const
{
	return game.launcher;
}

const Chooser&
Game_Elements_Accessor::get_chooser() const
{
	return game.chooser;
}

const Timeout_Meter&
Game_Elements_Accessor::get_timeout_meter() const
{
	return game.timeout_meter;
}

const Grid_Shaker&
Game_Elements_Accessor::get_grid_shaker() const
{
	return game.grid_shaker;
}

const Ambient_Effects_Manager&
Game_Elements_Accessor::get_ambient_effects_manager() const
{
	return game.ambient_effects_manager;
}

const Launched_Ball_Manager&
Game_Elements_Accessor::get_launched_ball_manager() const
{
	return game.launched_ball_manager;
}

const Popped_Balls_Manager&
Game_Elements_Accessor::get_popped_balls_manager() const
{
	return game.popped_balls_manager;
}

const Grid&
Game_Elements_Accessor::get_grid() const
{
	return game.grid;
}

Game::Game(Game_Manager& arg_gmgr)
 : game_manager(arg_gmgr),

   out_of_game_state(*this),
   gameplay_state(*this),
   game_over_state(*this),
   finished_level_state(*this),

   grid(*this, Vars::grid_rows, Vars::grid_cols, Vars::ball_radius,
	Vars::max_grid_move_count),
   launcher(*this),
   chooser(*this),
   timeout_meter(*this),
   grid_shaker(*this),
   ambient_effects_manager(*this),
   launched_ball_manager(*this),
   popped_balls_manager(*this),

   time_to_exit(false)
{
	ambient_effects_manager.drawing_enabled = true;
	current = &out_of_game_state;
	current->entry();
}

void
Game::set_state(int32_t arg) throw(Bad_State_Error)
{
	if(arg == NONE)
		throw Bad_State_Error("Game::set_state() - arg = NONE");

	current->exit();

	switch(arg) {
	case OUT_OF_GAME: current = &out_of_game_state; break;
	case GAME_OVER: current = &game_over_state; break;
	case FINISHED_LEVEL: current = &finished_level_state; break;
	case GAMEPLAY: current = &gameplay_state; break;
	default:
		break;
	} // switch(arg) {

	current->entry();
}

void
Game::tock(uint32_t tock_no)
{
	current->tock(tock_no);
}

void
Game::tick(uint32_t delta)
{
	current->tick(delta);
}

void
Game::sync_tick(uint32_t delta)
{
	current->sync_tick(delta);
}



} // namespace XBobble

