/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ambient_Effects_Manager.cc @see Ambient_Effects_Manager.hh */

#include "Ambient_Effects_Manager.hh"
#include "Grid.hh"
#include "gameplay_variables.hh"
#include "Game_Manager.hh"
#include <vector>
#include <SDL_opengl.h>

namespace XBobble
{

class Ambient_Effects_Manager::Impl
{
	/// Init arrays to the right size
	Impl()
	 : main_light_position(4, 0)
	{
	}

	friend class Ambient_Effects_Manager;

	/// Light pos cached here for use in draw_handler()
	std::vector<float> main_light_position;

}; // class Ambient_Effects_Manager::Impl

Ambient_Effects_Manager::Ambient_Effects_Manager(Game::Impl& arg)
 : Game_Element(arg), impl(new Impl())
{
    try
    {
    }
    catch(...)
    {
	    delete impl;
	    throw;
    }
}

void
Ambient_Effects_Manager::tock_handler(uint32_t tocks_passed)
{
}

void
Ambient_Effects_Manager::tick_handler(uint32_t delta)
{
//	User_Input_Manager& ui = game.game_manager.system.user_input_manager;
}

void
Ambient_Effects_Manager::sync_tick_handler(uint32_t delta)
{
}

void
Ambient_Effects_Manager::draw_handler() const
{
}

void
Ambient_Effects_Manager::enable_drawing_handler(bool arg)
{
	switch(arg) {
	case true: {
// 		glEnable(GL_LIGHT2);
// 		const float light2_ambient[4] = {0.0f, 0.0f, 0.0f, 1.0f};
// 		const float light2_diffuse[4] = {0.7f, 0.7f, 0.7f, 1.0f};
// 		const float light2_specular[4] = {1.0f, 1.0f, 1.0f, 1.0f};
// 		const float light2_position[4] = {0.0f, 0.0f, -30.0f, 1.0f};
// 		glLightfv(GL_LIGHT2, GL_AMBIENT, light2_ambient);
// 		glLightfv(GL_LIGHT2, GL_DIFFUSE, light2_diffuse);
// 		glLightfv(GL_LIGHT2, GL_SPECULAR, light2_specular);
// 		glLightfv(GL_LIGHT2, GL_POSITION, light2_position);

		if(game.game_manager.get_lod() != 1) {
			impl->main_light_position[0] = 0;
			impl->main_light_position[1] = 30;
			impl->main_light_position[2] = -150;
			impl->main_light_position[3] = 0;
			std::vector<float> diftmp(4, 0.9f);
			glLightfv(GL_LIGHT0, GL_DIFFUSE, &diftmp[0]);
		} else {
			impl->main_light_position[0] = -30;
			impl->main_light_position[1] = 50;
			impl->main_light_position[2] = -150;
			impl->main_light_position[3] = 0;
			glLightfv(GL_LIGHT0, GL_DIFFUSE,
				  Vars::main_light_diffuse);
		}
		glLightfv(GL_LIGHT0, GL_AMBIENT, Vars::main_light_ambient);
		glLightfv(GL_LIGHT0, GL_SPECULAR, Vars::main_light_specular);
		glLightfv(GL_LIGHT0, GL_POSITION,
			  &impl->main_light_position[0]);
		break;
	}

	case false:
		glDisable(GL_LIGHT2);
		break;

	default:
		break;

	} // switch(arg) {
}

} // namespace XBobble


