/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ball.hh A Ball.  How much more info do you need?!! */

#ifndef XBOBBLE_BALL_HH
#define XBOBBLE_BALL_HH

#include <ayq/stdint.h>
#include <cstddef>
#include "util.hh"

namespace XBobble
{

class Launched_Ball_Manager;
class Popped_Balls_Manager;
class Ball_Trait;

/** A Ball on the grid.  Advancement of the ball position and drawing
    of it is taken care of by 'Launched_Ball_Manager' if this is the
    launched ball, and 'Popped_Balls_Manager' if this is a popped
    ball.  Thus, this only has to worry about managing its trait. */
class Ball
{
public:
	/** Default constructor init all attributes by args. */
	Ball(std::size_t argtrait,
	     float pos_x = 0.0f, float pos_y = 0.0f,
	     float vel_x = 0.0f, float vel_y = 0.0f);

	/// As above, but use V2D objects for init
	Ball(std::size_t argtrait, const V2D& argpos, const V2D& argvel);

	/// Blah
	Ball(const Ball& arg)
	 : trait(arg.trait), pos(arg.pos), vel(arg.vel)
	{
	}

	/// Blah
	Ball&
	operator=(const Ball& arg)
	{
		pos = arg.pos; vel = arg.vel; trait = arg.trait;
		return *this;
	}

	/// Returns ball trait index
	std::size_t
	get_trait_index() const {return trait;}

	/// Returns ball trait index
	std::size_t
	get_trait() const {return trait;}

	/// Returns 'pos'
	const V2D&
	get_pos() const
	{
		return pos;
	}

	/// Returns 'vel
	const V2D&
	get_vel() const
	{
		return vel;
	}

private:
	friend class Launched_Ball_Manager;
	friend class Popped_Balls_Manager;
	friend class Launcher;
	friend class Chooser;

	/** Index into Grid::traits_list for this ball */
	std::size_t trait;

	/** Velocity vector.  Positional vector is where the ball is
	    at the moment.  Velocity vector serves two purposes: its
	    direction determines the direction in which travel will
	    start, and its magnitude determines the distance of total
	    travel (in units per tick).

	    ie. these are parts of an equation P = pos + t * vel,
	    where 't' is a constant, and P is a new positional
	    vector. */
	V2D pos, vel;

}; // Ball


} // namespace XBobble


#endif // #define XBOBBLE_BALL_HH

