/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ball_Trait.cc @see Ball_Trait.hh */

#include "Ball_Trait.hh"
#include "util.hh"
#include <SDL_opengl.h>

namespace XBobble
{


Ball_Trait::Ball_Trait(const uint32_t lod, const float radius,
		       const float params[13])
 : users(0), shared_owners(new unsigned long(1))
{
	const float shininess = params[0];
	const float* ambient(params+1);
	const float* diffuse(params+5);
	const float* specular(params+9);

	// Use lod to specify various stats for ball
	GLint slices, stacks;

	switch(lod) {
	default:
	case 1:
		slices = 35;
		stacks = 25;
		break;

	case 2:
		slices = 20;
		stacks = 10;
		break;

	case 3:
		slices = 12;
		stacks = 5;
		break;

	} // switch(lod)

	// Create a display list for the ball, to be used over
	// and over again (etc)
	one_ball_dl = glGenLists(1);

	GLUquadric* quadric = gluNewQuadric();

	glNewList(one_ball_dl, GL_COMPILE); {
		glMaterialf(GL_FRONT, GL_SHININESS, shininess);
		glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
		gluSphere(quadric, radius, slices, stacks);
	}; glEndList();

	gluDeleteQuadric(quadric);
}

Ball_Trait::Ball_Trait(const Ball_Trait& arg) throw()
 : users(0), one_ball_dl(arg.one_ball_dl), shared_owners(arg.shared_owners)
{
	++*shared_owners;
}

Ball_Trait&
Ball_Trait::operator=(const Ball_Trait& arg) throw()
{
	if(this != &arg) {
		delete shared_owners;
		glDeleteLists(one_ball_dl, 1);
		shared_owners = arg.shared_owners;
		++*shared_owners;
		one_ball_dl = arg.one_ball_dl;
		
	}
	return *this;
}

Ball_Trait::~Ball_Trait()
{
	if(--*shared_owners == 0) {
		delete shared_owners;
		glDeleteLists(one_ball_dl, 1);
	}
}

void
Ball_Trait::draw_commands() const
{
	if(!glIsList(one_ball_dl))
		throw Paranoia_Confirmed_Error("Ball_Trait::draw_commands()");
	glCallList(one_ball_dl);
}


} // namespace XBobble



