/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Chooser.hh */

#ifndef XBOBBLE_CHOOSER_HH
#define XBOBBLE_CHOOSER_HH

#include <ayq/stdint.h>
#include "Game_Element.hh"
#include "Video_Data.hh"
#include "Ball.hh"

namespace XBobble
{

class Game;
class Ball;

/// Chooses and creates the next ball, and hands it to Launcher.
class Chooser : public Game_Element, public Video_Data
{
public:
	/// Init with arg; sets 'next_ball' to 0 (NULL), so call
	/// 'next_ball' before anything
	Chooser(Game::Impl& arg);

	/// Draw the chooser animation (basically a pot, from which a
	/// ball rolls out into the launcher)
	void
	draw_handler() const;

	/// Returns the trait of the next ball, and chooses a new next
	/// ball, and starts the animation to load the old next ball
	/// to the launcher. If this function is called again, jumps
	/// to the end of the current animation.
	std::size_t
	get_next_ball();

	/// Resets stuff
	void
	reset();

private:
	/// Next ball
	Ball ball;

}; // class Chooser



} // namespace XBobble

#endif // #define XBOBBLE_CHOOSER_HH

