/* Copyright (C) 2002,2003 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Game.hh Game class */

#ifndef XBOBBLE_GAME_HH
#define XBOBBLE_GAME_HH

#include <ayq/stdint.h>
#include <stdexcept>

namespace XBobble
{

class Game_Manager;
class Game_Elements_Accessor;
class Grid;
class Chooser;
class Launcher;
class Timeout_Meter;
class Grid_Shaker;
class Ambient_Effects_Manager;
class Launched_Ball_Manager;
class Popped_Balls_Manager;
class State;
class Out_Of_Game_State;
class Gameplay_State;
class Game_Over_State;
class Finished_Level_State;

/// The main game class.  Mediates all other classes used for game and
/// acts as a state machine for game
class Game
{
public:
	/// Default - constructs all owned objects
	Game(Game_Manager& arg_gmgr);

	/// Delete pimpl
	virtual
	~Game();

	/// The Game_Manager object that mediates us
	Game_Manager& game_manager;

	class Impl;
private:
	Impl* impl;

	//@{
	/// Game element
	Grid& grid;
	Chooser& chooser;
	Launcher& launcher;
	Timeout_Meter& timeout_meter;
	Grid_Shaker& grid_shaker;
	Ambient_Effects_Manager& ambient_effects_manager;
	Launched_Ball_Manager& launched_ball_manager;
	Popped_Balls_Manager& popped_balls_manager;
	//@}

	/// Derive from this "Game_Elements_Accessor" to have
	/// access to Game elements
	///
	/// @see Game_Elements_Accessor
	friend class Game_Elements_Accessor;

// State related

public:
	/// The possible states
	enum {
		NONE,
		OUT_OF_GAME,
		GAME_OVER,
		FINISHED_LEVEL,
		GAMEPLAY,
	}; // enum {

private:
	//@{
	/// Game state
	Out_Of_Game_State& out_of_game_state;
	Gameplay_State& gameplay_state;
	Game_Over_State& game_over_state;
	Finished_Level_State& finished_level_state;
	//@}

	/// The current state
	State* current;

public:
	/// Calls 'exit()' of current state, sets the current state to
	/// the given state and calls 'entry()' on the given state.
	void
	set_state(int32_t arg);

public:
	/// Process a tock
	void
	tock(uint32_t tock_no);

	/// Tick func
	void
	tick(uint32_t delta);

	/// Synching func
	void
	sync_tick(uint32_t delta);

}; // class Game

} // namespace XBobble {

#endif // #define XBOBBLE_GAME_HH


