/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Game_Elements_Accessor.hh Defines a class that allows access
    to the game elements of a Game class.

    @see Game.hh Game.cc */

#ifndef XBOBBLE_GAME_ELEMENTS_ACCESSOR_HH
#define XBOBBLE_GAME_ELEMENTS_ACCESSOR_HH

#include "Game.hh"

namespace XBobble
{

/// A class can either derive from this class or create an object of
/// this class, and access the game elements of a Game object.
class Game_Elements_Accessor
{
public:
	/// Initialise so we can access game elements of Game object
	/// "arg".
	Game_Elements_Accessor(Game::Impl& arg);

	/// Because It Should Be There (tm)
	virtual
	~Game_Elements_Accessor()
	{
	}

	//@{
	///Game element
	Launcher&
	get_launcher();

	Chooser&
	get_chooser();

	Timeout_Meter&
	get_timeout_meter();

	Grid_Shaker&
	get_grid_shaker();

	Ambient_Effects_Manager&
	get_ambient_effects_manager();

	Launched_Ball_Manager&
	get_launched_ball_manager();

	Popped_Balls_Manager&
	get_popped_balls_manager();

	Grid&
	get_grid();

	const Launcher&
	get_launcher() const;

	const Chooser&
	get_chooser() const;

	const Timeout_Meter&
	get_timeout_meter() const;

	const Grid_Shaker&
	get_grid_shaker() const;

	const Ambient_Effects_Manager&
	get_ambient_effects_manager() const;

	const Launched_Ball_Manager&
	get_launched_ball_manager() const;

	const Popped_Balls_Manager&
	get_popped_balls_manager() const;

	const Grid&
	get_grid() const;
	//@}

protected:
	/// The Game objects implementation whose game elements to
	/// access
	Game::Impl& game_impl;

	/// The game object
	Game& game;

	/// Game manager - obtained from game_impl's owner.
	Game_Manager& game_manager;

}; // class Game_Elements_Accessor


} // namespace XBobble

#endif // #define XBOBBLE_GAME_ELEMENTS_ACCESSOR_HH

