/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Launched_Ball_Manager.hh */

#ifndef XBOBBLE_LAUNCHED_BALL_MANAGER_HH
#define XBOBBLE_LAUNCHED_BALL_MANAGER_HH

#include <ayq/stdint.h>
#include "Game_Element.hh"
#include "Video_Data.hh"
#include "Ball.hh"

namespace XBobble
{

class Game;
class Ball;

/// Manages launched ball physics
class Launched_Ball_Manager : public Game_Element, public Video_Data
{
public:
	/// Init with arg - ball initially set to 'none'
	Launched_Ball_Manager(Game::Impl& arg);

	/// Blah
	bool
	get_ball_stopped() const
	{
		return ball_stopped;
	}

	/// Give a ball to be launched.
	void
	add_ball(const Ball& arg);

private:
	/// Draw the ball (if there is one)
	void
	draw_handler() const;

	/// Enable/disable drawing in sync with tock func processing
	void
	enable_tock_funcs_handler(bool arg)
	{
		enable_drawing(arg);
	}

	/// Ball collision detection/etc.
	void
	sync_tick_handler(uint32_t);

	/// The ball to draw
	Ball ball;

	/// Is the ball stopped, or going still?
	bool ball_stopped;

}; // class Launched_Ball_Manager


} // namespace XBobble

#endif // #define XBOBBLE_LAUNCHED_BALL_MANAGER_HH

