/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Launcher.hh The Launcher! */

#ifndef XBOBBLE_LAUNCHER_HH
#define XBOBBLE_LAUNCHER_HH

#include <ayq/stdint.h>
#include "Video_Data.hh"
#include "Game_Element.hh"
#include "util.hh"

namespace XBobble
{

class Game;

/// Launches the ball at a user-specified angle, between -80 and 80
/// degrees to the vertical.  Position: 1 ball's diameter down from
/// the bottom of the grid.
class Launcher : public Game_Element, public Video_Data
{
public:
	/// Init launcher
	Launcher(Game::Impl& arg);

	/// Destroy impl
	virtual
	~Launcher();

private:
	/// Draws the launcher
	void
	draw_handler() const;

	/// Handles tocks
	void
	tock_handler(uint32_t);

public:
	/// Gets the 'angle'
	float
	get_angle() const;

	/// Launch the ball and get the next ball.
	void
	launch();

	/// Reset angle
	void
	reset();

private:
	/// Enable/disable video_data according to tock_funcs state
	void
	enable_tock_funcs_handler(bool arg)
	{
		enable_drawing(arg);
	}

	/// Additional stuff to do when enabling/disabling drawing
	void
	enable_drawing_handler(bool);

	/// Yep
	class Impl;

	/// Oh yeah...
	Impl* impl;

}; // class Launcher


} // namespace XBobble


#endif // #define XBOBBLE_LAUNCHER_HH
