/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Popped_Balls_Manager.hh */

#ifndef XBOBBLE_POPPED_BALLS_MANAGER_HH
#define XBOBBLE_POPPED_BALLS_MANAGER_HH

#include <ayq/stdint.h>
#include "Game_Element.hh"
#include "Video_Data.hh"
#include "util.hh"

namespace XBobble
{

class Game;
class Ball;

/// Manages popped balls physics (ie those that have left the grid).
class Popped_Balls_Manager : public Game_Element, public Video_Data
{
public:
	/// Init with arg
	Popped_Balls_Manager(Game::Impl& arg);

	/// Add a ball to be 'popped and dropped'.
	void
	add_ball(const Ball& b);

	/// Should be obvious
	void
	reset();

	/// Make this using Vars::gravity
	static const V2D gravity_vector;

private:
	/// Draw the balls
	void
	draw_handler() const;

	/// Enable/disable video_data according to tock_funcs state
	void
	enable_tock_funcs_handler(bool arg)
	{
		enable_drawing(arg);
	}

	/// Adjusts velocity depending on time passed and 'gravity'
	/// constant
	void
	tock_handler(uint32_t tocks);

	// Dunno mate
	void
	tick_handler(uint32_t);

	/// Yep
	class Impl;

	/// Oh yeah...
	Impl* impl;

}; // class Popped_Balls_Manager


} // namespace XBobble

#endif // #define XBOBBLE_POPPED_BALLS_MANAGER_HH

