/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Sound_Output_Manager.cc @see Sound_Output_Manager.hh */

#include <cstdlib>
#include <string>
#include "Sound_Output_Manager.hh"
#include "System.hh"
#include "Game_Manager.hh"
#include "Sound_Data.hh"

namespace XBobble
{

Sound_Output_Manager::Sound_Output_Manager(System& arg_sys)
 : Singleton_Class("Sound_Output_Manager"), system(arg_sys),
   used_channels(0)
{
	Game_Manager& gm = system.game_manager;
	int bufsize = 1024; // default
	std::string opt = gm.get_option("sound_buffer_size");
	if(opt != "")
		bufsize = atoi(opt.c_str());
	if(Mix_OpenAudio(MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT,
			 2, bufsize) == -1)
		throw Init_Error("Sound_Output_Manager() - Mix_OpenAudio");
	Mix_AllocateChannels(32);
}

void
Sound_Output_Manager::load_sound(const std::string& arg, Sound_Data& data)
{
	if(arg.size() == 0)
		throw std::invalid_argument(
			"Sound_Output_Manager::load_sound() - "
			"empty filename");

	if(used_channels == 32) {
		throw std::logic_error(
			"Sound_Output_Manager::load_sound() - "
			" too many channels when trying to open file\n"
			+ arg);
	}

	std::string filename;

	if(arg.at(0) == '/')
		filename = arg;
	else
		filename
			= system.game_manager.get_option("data_root")
			+ "/" + arg;

	Mix_Chunk* sample;

	if((sample = Mix_LoadWAV(filename.c_str())) == 0)
		throw std::invalid_argument(
			std::string("Sound_Output_Manager::load_sound() - ")
			+ "invalid filename " + arg);

	data.channel = used_channels;
	++used_channels;
	data.sample = sample;
}



} // namespace XBobble

