/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file State.hh Header for the State class, father of all states;
    also some other smaller state classes. */

#ifndef XBOBBLE_STATE_HH
#define XBOBBLE_STATE_HH

#include <stdexcept>
#include <string>
#include <ayq/stdint.h>
#include "Game_Elements_Accessor.hh"

namespace XBobble
{

class Game;

/// Exception thrown when an error relating to a state is detected
class Bad_State_Error : public std::logic_error
{
public:
	Bad_State_Error(const std::string& arg)
	 : std::logic_error(arg)
	{
	}

}; // class Bad_State_Error


/// Base class for all states
class State : public Game_Elements_Accessor
{
public:
	/// Init with game
	State(Game::Impl& arg)
	 : Game_Elements_Accessor(arg)
	{
	}

	/// Because It Should Be There(tm)
	virtual
	~State()
	{
	}

	/// Call on entering this state
	virtual void
	entry() = 0;

	/// Call on leaving this state
	virtual void
	exit() = 0;

	/// Do tock processing
	virtual void
	tock(uint32_t) = 0;

	/// Tick-based function for this state
	virtual void
	tick(uint32_t) = 0;

	/// Sync-tick function for this state
	virtual void
	sync_tick(uint32_t) = 0;

}; // class State



} // namespace XBobble

#endif// #define XBOBBLE_STATE_HH


