/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file System.hh Access to system, in this case SDL. */

#ifndef XBOBBLE_SYSTEM_HH
#define XBOBBLE_SYSTEM_HH

#include <ayq/stdint.h>
#include "util.hh"
#include "Video_Output_Manager.hh"
#include "Sound_Output_Manager.hh"
#include "User_Input_Manager.hh"
#include <SDL.h>

namespace XBobble
{

class Game_Manager;

/// Global system class.  A mediator for User_Output_Manager and
/// User_Input_Manager, as well as housing various other system
/// functions.  Singleton.
class System : public Singleton_Class
{
public:
	/// Ticks counter that makes 'System' a suitable template
	/// parameter for Tock_Manager
	static inline uint32_t
	get_ticks()
	{
		return SDL_GetTicks();
	}

	/// Inits SDL, so construct this object before the other
	/// managers.  Singleton.
	class SDL_Initialiser : public Singleton_Class
	{
	public:
		/// Init SDL or throw Init_Error.
		SDL_Initialiser();

		/// Destructor uninitialises SDL.  Won't be called if
		/// SDL wasn't init.  Good, eh?
		~SDL_Initialiser();

	}; // class SDL_Initialiser

	/// Default constructor.
	///
	/// @see Game_Manager
	System(Game_Manager& g);

	/// Call this to signal a quit event which will eventually end
	/// the whole game.
	void
	signal_exit();

	/// "My master..."
	Game_Manager& game_manager;

protected:
	/// Init SDL before the other subsystems
	SDL_Initialiser sdl_initialiser;

public:
	Video_Output_Manager video_output_manager;

	Sound_Output_Manager sound_output_manager;

	User_Input_Manager user_input_manager;

}; // class System


} // namespace XBobble

#endif// #define XBOBBLE_SYSTEM_HH


