/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file gameplay_variables.cc @see gameplay_variables.hh */

#include "gameplay_variables.hh"

namespace XBobble
{

namespace Vars
{

// Following are mentioned in 'gameplay_variables.hh'

extern const uint32_t grid_rows = 13, grid_cols = 8;

extern const float ball_radius = 11;

extern const uint32_t tock_size = 20; // 50 tocks per second

extern const float launch_speed = 0.3f;

extern const float max_launch_angle = 75.0f;

extern const float max_degrees_per_tock = 1.3f;

extern const float main_light_ambient[4] = {0.2, 0.2, 0.2, 1.0f};
extern const float main_light_diffuse[4] = {0.6, 0.6, 0.6, 1.0f};
extern const float main_light_specular[4] = {1.0f, 1.0f, 1.0f, 1.0f};

// Following are not mentioned in gameplay_variables.hh, and should be
// pre-declared before use.

/// Gravity, in units per tick
extern const float gravity = 0.0002f;

/// Initial 'popped balls' velocity vector [units/tock]
extern const float popped_vv_x = 0.08f, popped_vv_y = -0.22f;

/// Number of traits (as below)
extern const uint32_t num_traits = 8;

/// Min number of consecutive touching balls that will be popped.
extern const uint32_t min_same_trait_balls = 3;

/// For the next things
const float ambi = 0.35f;

/// Description of traits; idx 0-3=ambient, idx 4-7=diffuse, idx
/// 8-11=specular, 12=shininess
extern const float traits[num_traits][13] = {
	{ // Trait 0 - dull red plastic ball
		15.0f,
		ambi, ambi, ambi, 1.0f,
		0.5f, 0.2f, 0.2f, 1.0f,
		0.2f, 0.2f, 0.2f, 0.2f,
	},
	{ // Trait 1 - dark green plastic ball
		10.0f,
		ambi, ambi, ambi, 1.0f,
		0.0f, 0.6f, 0.0f, 1.0f,
		0.2f, 0.2f, 0.2f, 1.0f,
	},
	{ // Trait 2 - dark blue metal ball
		90.0f,
		ambi, ambi, ambi, 1.0f,
		0.0f, 0.0f, 0.9f, 1.0f,
		1.0f, 1.0f, 1.0f, 1.0f,
	},
	{ // Trait 3 - bright yellow shiny plastic ball
		0.0f,
		ambi, ambi, ambi, 1.0f,
		1.0f, 1.0f, 0.0f, 1.0f,
		0.0f, 0.0f, 0.0f, 1.0f,
	},
	{ // Trait 4 - super shiny black ball
		70.0f,
		0.0f, 0.0f, 0.0f, 1.0f,
		0.3f, 0.3f, 0.3f, 1.0f,
		1.0f, 1.0f, 1.0f, 1.0f,
	},
	{ // Trait 5 - skyblue dull plastic ball
		30.0f,
		ambi, ambi, ambi, 1.0f,
		0.3f, 0.5f, 1.0f, 1.0f,
		0.4f, 0.4f, 0.4f, 1.0f,
	},
	{ // Trait 6 - half-shiny light-purple ball
		60.0f,
		ambi, ambi, ambi, 1.0f,
		0.45f, 0.18f, 0.5f, 1.0f,
		0.5f, 0.5f, 0.5f, 1.0f,
	},
	{ // Trait 7 - shiny rough brown ball
		15.0f,
		ambi, ambi, ambi, 1.0f,
		0.6f, 0.5f, 0.3f, 1.0f,
		0.5f, 0.5f, 0.5f, 1.0f,
	},
};

} // namespace Vars

} // namespace XBobble


