/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file gameplay_variables.hh All variables that affect gameplay are
    here for convenient access. */

#ifndef XBOBBLE_GAMEPLAY_VARIABLES_HH
#define XBOBBLE_GAMEPLAY_VARIABLES_HH

#include <ayq/stdint.h>

namespace XBobble
{

namespace Vars
{

/// Various Grid stats - they musn't change after level-loading code
/// is put in place!
extern const uint32_t grid_rows, grid_cols, max_grid_move_count;

/// The radius of balls in the grid
extern const float ball_radius;

/// The length of a tock
extern const uint32_t tock_size; // 50 tocks per second

/// The speed (in units per tock [u/t]) given to the ball when it is
/// launched from the Launcher
extern const float launch_speed;

/// Max angle (either way) allowed to launch ball
extern const float max_launch_angle;

/// The max number of degrees to turn the launcher per tock
extern const float max_degrees_per_tock;

// @{

/// Main light parameters
extern const float main_light_ambient[4];
extern const float main_light_diffuse[4];
extern const float main_light_specular[4];

// @}

} // namespace Vars

} // namespace XBobble


#endif // #define XBOBBLE_GAMEPLAY_VARIABLES_HH

